/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework;

import com.sun.jersey.api.core.ClassNamesResourceConfig;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;

public class LowLevelAppDescriptor
extends AppDescriptor {
    private final ResourceConfig rc;
    private final String contextPath;

    private LowLevelAppDescriptor(Builder b) {
        super(b);
        this.contextPath = b.contextPath;
        this.rc = b.rc;
    }

    public ResourceConfig getResourceConfig() {
        return this.rc;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public static LowLevelAppDescriptor transform(WebAppDescriptor wad) {
        String packages = wad.getInitParams().get("com.sun.jersey.config.property.packages");
        return new Builder(packages).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AppDescriptor.AppDescriptorBuilder<Builder, LowLevelAppDescriptor> {
        protected final ResourceConfig rc;
        protected String contextPath = "";

        public Builder(String ... packages) throws IllegalArgumentException {
            if (packages == null) {
                throw new IllegalArgumentException("The packages must not be null");
            }
            this.rc = new PackagesResourceConfig(packages);
        }

        public Builder(Class ... classes) throws IllegalArgumentException {
            if (classes == null) {
                throw new IllegalArgumentException("The classes must not be null");
            }
            this.rc = new ClassNamesResourceConfig(classes);
        }

        public Builder(ResourceConfig rc) {
            if (rc == null) {
                throw new IllegalArgumentException("The resource configuration must not be null");
            }
            this.rc = rc;
        }

        public Builder contextPath(String contextPath) {
            if (contextPath == null) {
                throw new IllegalArgumentException("The context path must not be null");
            }
            this.contextPath = contextPath;
            return this;
        }

        @Override
        public LowLevelAppDescriptor build() {
            LowLevelAppDescriptor lld = new LowLevelAppDescriptor(this);
            this.reset();
            return lld;
        }

        @Override
        protected void reset() {
            super.reset();
            this.contextPath = "";
        }
    }
}

