/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.spi.resource.Singleton;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Resources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.Marshaller;

@Produces(value={"application/vnd.sun.wadl+xml", "application/xml"})
@Singleton
public final class WadlResource {
    private static final Logger LOGGER = Logger.getLogger(WadlResource.class.getName());
    private WadlApplicationContext wadlContext;
    private Application application;
    private byte[] wadlXmlRepresentation;

    public WadlResource(@Context WadlApplicationContext wadlContext) {
        this.wadlContext = wadlContext;
        this.application = wadlContext.getApplication();
    }

    @GET
    public synchronized Response getWadl(@Context UriInfo uriInfo) {
        if (!this.wadlContext.isWadlGenerationEnabled()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.wadlXmlRepresentation == null) {
            for (Resources resources : this.application.getResources()) {
                if (resources.getBase() != null) continue;
                resources.setBase(uriInfo.getBaseUri().toString());
            }
            try {
                Marshaller marshaller = this.wadlContext.getJAXBContext().createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                marshaller.marshal((Object)this.application, (OutputStream)os);
                this.wadlXmlRepresentation = os.toByteArray();
                os.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not marshal wadl Application.", e);
                return Response.ok((Object)this.application).build();
            }
        }
        return Response.ok((Object)new ByteArrayInputStream(this.wadlXmlRepresentation)).build();
    }
}

