/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.core;

import com.sun.jersey.api.core.ResourceConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceConfig
extends ResourceConfig {
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final Set<Object> singletons = new LinkedHashSet<Object>();
    private final Map<String, MediaType> mediaExtentions = new HashMap<String, MediaType>();
    private final Map<String, String> languageExtentions = new HashMap<String, String>();
    private final Map<String, Object> explicitRootResources = new HashMap<String, Object>();
    private final Map<String, Boolean> features = new HashMap<String, Boolean>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultResourceConfig() {
        this((Set)null);
    }

    public DefaultResourceConfig(Class<?> ... classes) {
        this(new HashSet(Arrays.asList(classes)));
    }

    public DefaultResourceConfig(Set<Class<?>> classes) {
        if (null != classes) {
            this.classes.addAll(classes);
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    @Override
    public Map<String, MediaType> getMediaTypeMappings() {
        return this.mediaExtentions;
    }

    @Override
    public Map<String, String> getLanguageMappings() {
        return this.languageExtentions;
    }

    @Override
    public Map<String, Object> getExplicitRootResources() {
        return this.explicitRootResources;
    }

    @Override
    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    @Override
    public boolean getFeature(String featureName) {
        Boolean v = this.features.get(featureName);
        return v != null ? v : false;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public static String[] getElements(String[] elements) {
        LinkedList<String> es = new LinkedList<String>();
        for (String element : elements) {
            if (element == null || (element = element.trim()).length() == 0) continue;
            for (String subElement : DefaultResourceConfig.getElements(element)) {
                if (subElement == null || subElement.length() == 0) continue;
                es.add(subElement);
            }
        }
        return es.toArray(new String[es.size()]);
    }

    private static String[] getElements(String elements) {
        String[] es = elements.split(";");
        for (int i = 0; i < es.length; ++i) {
            es[i] = es[i].trim();
        }
        return es;
    }
}

