/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.uri.rules;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.core.header.AcceptableMediaType;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpMethodRule
implements UriRule {
    private final Map<String, List<ResourceMethod>> map;
    private final String allow;
    private final boolean isSubResource;

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods) {
        this(methods, false);
    }

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods, boolean isSubResource) {
        this.map = methods;
        this.isSubResource = isSubResource;
        this.allow = this.getAllow(methods);
    }

    private String getAllow(Map<String, List<ResourceMethod>> methods) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (String method : methods.keySet()) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(method);
        }
        return s.toString();
    }

    @Override
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        if (path.length() > 0) {
            return false;
        }
        HttpRequestContext request = context.getRequest();
        HttpResponseContext response = context.getResponse();
        List<ResourceMethod> methods = this.map.get(request.getMethod());
        if (methods == null) {
            response.setResponse(Responses.methodNotAllowed().header("Allow", (Object)this.allow).build());
            return false;
        }
        List accept = request.getAcceptableMediaTypes();
        Matcher m = new Matcher();
        MatchStatus s = m.match(methods, request.getMediaType(), accept);
        if (s == MatchStatus.MATCH) {
            ResourceMethod method = m.rmSelected;
            if (this.isSubResource) {
                context.pushResource(resource);
                context.pushMatch(method.getTemplate(), method.getTemplate().getTemplateVariables());
            }
            method.getDispatcher().dispatch(resource, context);
            Object contentType = response.getHttpHeaders().getFirst((Object)"Content-Type");
            if (contentType == null && m.rmSelected.isProducesDeclared() && !m.mSelected.isWildcardType() && !m.mSelected.isWildcardSubtype()) {
                response.getHttpHeaders().putSingle((Object)"Content-Type", (Object)m.mSelected);
            }
            return true;
        }
        if (s == MatchStatus.NO_MATCH_FOR_CONSUME) {
            response.setResponse(Responses.unsupportedMediaType().build());
            return false;
        }
        if (s == MatchStatus.NO_MATCH_FOR_PRODUCE) {
            response.setResponse(Responses.notAcceptable().build());
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Matcher
    extends LinkedList<ResourceMethod> {
        private MediaType mSelected = null;
        private ResourceMethod rmSelected = null;

        private Matcher() {
        }

        private MatchStatus match(List<ResourceMethod> methods, MediaType contentType, List<MediaType> acceptableMediaTypes) {
            Matcher selected = null;
            if (contentType != null) {
                for (ResourceMethod method : methods) {
                    if (!method.consumes(contentType)) continue;
                    this.add(method);
                }
                if (this.isEmpty()) {
                    return MatchStatus.NO_MATCH_FOR_CONSUME;
                }
                selected = this;
            } else {
                selected = methods;
            }
            int currentQuality = 0;
            for (ResourceMethod rm : selected) {
                int quality = -1;
                MediaType m = null;
                Iterator<MediaType> amtIterator = acceptableMediaTypes.iterator();
                block2: while (quality < 0 && amtIterator.hasNext()) {
                    AcceptableMediaType amt = (AcceptableMediaType)amtIterator.next();
                    for (MediaType p : rm.getProduces()) {
                        if (!p.isCompatible((MediaType)amt)) continue;
                        quality = amt.getQuality();
                        m = MediaTypes.mostSpecific((MediaType)p, (MediaType)amt);
                        continue block2;
                    }
                }
                if (quality <= currentQuality) continue;
                currentQuality = quality;
                this.mSelected = m;
                this.rmSelected = rm;
            }
            if (this.mSelected == null) {
                return MatchStatus.NO_MATCH_FOR_PRODUCE;
            }
            return MatchStatus.MATCH;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchStatus {
        MATCH,
        NO_MATCH_FOR_CONSUME,
        NO_MATCH_FOR_PRODUCE;

    }
}

