/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.linking.impl;

import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.server.linking.el.LinkBuilder;
import com.sun.jersey.server.linking.impl.EntityDescriptor;
import com.sun.jersey.server.linking.impl.FieldDescriptor;
import com.sun.jersey.server.linking.impl.RefFieldDescriptor;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriInfo;

public class RefProcessor<T> {
    private EntityDescriptor instanceDescriptor;
    private static final Logger log = Logger.getLogger(RefProcessor.class.getName());

    public RefProcessor(Class<T> c) {
        this.instanceDescriptor = EntityDescriptor.getInstance(c);
    }

    public void processLinks(T entity, UriInfo uriInfo) {
        HashSet<Object> processed = new HashSet<Object>();
        Object resource = uriInfo.getMatchedResources().get(0);
        this.processLinks(entity, resource, entity, processed, uriInfo);
    }

    private void processLinks(Object entity, Object resource, Object instance, Set<Object> processed, UriInfo uriInfo) {
        try {
            if (instance == null || processed.contains(instance)) {
                return;
            }
            processed.add(instance);
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, ImplMessages.WARNING_LINKFILTER_PROCESSING((Object)instance.getClass().getName()), e);
        }
        for (RefFieldDescriptor linkField : this.instanceDescriptor.getLinkFields()) {
            if (!LinkBuilder.evaluateCondition(linkField.getCondition(), entity, resource, instance)) continue;
            URI uri = LinkBuilder.buildURI(linkField, entity, resource, instance, uriInfo);
            linkField.setPropertyValue(instance, uri);
        }
        Class<?> instanceClass = instance.getClass();
        if (instanceClass.isArray() && Object[].class.isAssignableFrom(instanceClass)) {
            Object[] array;
            for (Object member : array = (Object[])instance) {
                this.processMember(entity, resource, member, processed, uriInfo);
            }
        } else if (instance instanceof Collection) {
            Collection collection = (Collection)instance;
            for (Object member : collection) {
                this.processMember(entity, resource, member, processed, uriInfo);
            }
        }
        for (FieldDescriptor member : this.instanceDescriptor.getNonLinkFields()) {
            this.processMember(entity, resource, member.getFieldValue(instance), processed, uriInfo);
        }
    }

    private void processMember(Object entity, Object resource, Object member, Set<Object> processed, UriInfo uriInfo) {
        if (member != null) {
            RefProcessor proc = new RefProcessor(member.getClass());
            super.processLinks(entity, resource, member, processed, uriInfo);
        }
    }
}

