/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.json.impl;

import com.sun.jersey.api.json.JSONConfigurated;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.json.impl.Stax2JsonFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUnmarshaller
implements Unmarshaller,
JSONConfigurated {
    private Unmarshaller jaxbUnmarshaller;
    private final JSONConfiguration jsonConfig;
    private boolean jsonEnabled;

    public JSONUnmarshaller(JAXBContext jaxbContext, JSONConfiguration jsonConfig) throws JAXBException {
        this.jsonConfig = jsonConfig;
        this.jaxbUnmarshaller = jaxbContext.createUnmarshaller();
    }

    public Object unmarshal(InputStream inputStream, Class<Object> type) throws JAXBException {
        if (this.jsonEnabled) {
            if (null != type) {
                return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(new InputStreamReader(inputStream)), type);
            }
            return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(new InputStreamReader(inputStream)));
        }
        return this.jaxbUnmarshaller.unmarshal(inputStream);
    }

    public Object unmarshal(Reader reader, Class<Object> type) throws JAXBException {
        if (this.jsonEnabled) {
            if (null != type) {
                return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader), type);
            }
            return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader));
        }
        return this.jaxbUnmarshaller.unmarshal(reader);
    }

    public Object unmarshal(File file) throws JAXBException {
        if (this.jsonEnabled) {
            try {
                return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(new FileReader(file)));
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(JSONUnmarshaller.class.getName()).log(Level.SEVERE, null, ex);
                throw new JAXBException((Throwable)ex);
            }
        }
        return this.jaxbUnmarshaller.unmarshal(file);
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        return this.unmarshal(inputStream, null);
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        return this.unmarshal(reader, null);
    }

    public Object unmarshal(URL url) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(url);
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(inputSource);
    }

    public Object unmarshal(Node node) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(node);
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(node, type);
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(source);
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(source, type);
    }

    public Object unmarshal(XMLStreamReader xmlStreamReader) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlStreamReader);
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader xmlStreamReader, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlStreamReader, type);
    }

    public Object unmarshal(XMLEventReader xmlEventReader) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlEventReader);
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader xmlEventReader, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlEventReader, type);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.jaxbUnmarshaller.getUnmarshallerHandler();
    }

    public void setValidating(boolean validating) throws JAXBException {
        this.jaxbUnmarshaller.setValidating(validating);
    }

    public boolean isValidating() throws JAXBException {
        return this.jaxbUnmarshaller.isValidating();
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.jaxbUnmarshaller.setEventHandler(validationEventHandler);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.jaxbUnmarshaller.getEventHandler();
    }

    public boolean isJsonEnabled() {
        return this.jsonEnabled;
    }

    public void setJsonEnabled(boolean jsonEnabled) {
        this.jsonEnabled = jsonEnabled;
    }

    public void setProperty(String key, Object value) throws PropertyException {
        this.jaxbUnmarshaller.setProperty(key, value);
    }

    public Object getProperty(String key) throws PropertyException {
        return this.jaxbUnmarshaller.getProperty(key);
    }

    public void setSchema(Schema schema) {
        this.jaxbUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.jaxbUnmarshaller.getSchema();
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        this.jaxbUnmarshaller.setAdapter(xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.jaxbUnmarshaller.setAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.jaxbUnmarshaller.getAdapter(type);
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        this.jaxbUnmarshaller.setAttachmentUnmarshaller(attachmentUnmarshaller);
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.jaxbUnmarshaller.getAttachmentUnmarshaller();
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.jaxbUnmarshaller.setListener(listener);
    }

    public Unmarshaller.Listener getListener() {
        return this.jaxbUnmarshaller.getListener();
    }

    private XMLStreamReader createXmlStreamReader(Reader reader) {
        return Stax2JsonFactory.createReader(reader, this.jsonConfig, this.jsonConfig.isRootUnwrapping() ? "rootElement" : null);
    }

    @Override
    public JSONConfiguration getJSONConfiguration() {
        return this.jsonConfig;
    }
}

