/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.core.spi.component.ProviderFactory;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCProviderFactory;
import com.sun.jersey.core.spi.factory.ContextResolverFactory;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.core.spi.factory.MessageBodyFactory;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends Filterable
implements ClientHandler {
    private final ProviderFactory componentProviderFactory;
    private final Providers providers;
    private boolean destroyed = false;
    private Map<String, Object> properties;

    public Client() {
        this(Client.createDefaultClientHander(), new DefaultClientConfig(), null);
    }

    public Client(ClientHandler root) {
        this(root, new DefaultClientConfig(), null);
    }

    public Client(ClientHandler root, ClientConfig config) {
        this(root, config, null);
    }

    public Client(ClientHandler root, ClientConfig config, IoCComponentProviderFactory provider) {
        super(root);
        InjectableProviderFactory injectableFactory = new InjectableProviderFactory();
        this.getProperties().putAll(config.getProperties());
        injectableFactory.add(new ContextInjectableProvider<ClientConfig>((Type)((Object)ClientConfig.class), config));
        this.componentProviderFactory = provider == null ? new ProviderFactory((InjectableProviderContext)injectableFactory) : new IoCProviderFactory((InjectableProviderContext)injectableFactory, provider);
        ProviderServices providerServices = new ProviderServices(injectableFactory, this.componentProviderFactory, config.getClasses(), config.getSingletons());
        injectableFactory.configure(providerServices);
        final ContextResolverFactory crf = new ContextResolverFactory(providerServices, injectableFactory);
        final MessageBodyFactory bodyContext = new MessageBodyFactory(providerServices);
        injectableFactory.add(new ContextInjectableProvider<MessageBodyFactory>((Type)((Object)MessageBodyWorkers.class), bodyContext));
        this.providers = new Providers(){

            public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return bodyContext.getMessageBodyReader(c, t, as, m);
            }

            public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return bodyContext.getMessageBodyWriter(c, t, as, m);
            }

            public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> c) {
                throw new IllegalArgumentException("This method is not supported on the client side");
            }

            public <T> ContextResolver<T> getContextResolver(Class<T> ct, MediaType m) {
                return crf.resolve(ct, m);
            }
        };
        injectableFactory.add(new ContextInjectableProvider<Providers>((Type)((Object)Providers.class), this.providers));
        bodyContext.init();
        this.componentProviderFactory.injectOnAllComponents();
        this.componentProviderFactory.injectOnProviderInstances(config.getSingletons());
        this.componentProviderFactory.injectOnProviderInstance((Object)root);
    }

    public void destroy() {
        if (!this.destroyed) {
            this.componentProviderFactory.destroy();
            this.destroyed = true;
        }
    }

    protected void finalize() {
        this.destroy();
    }

    public Providers getProviders() {
        return this.providers;
    }

    public WebResource resource(String u) {
        return this.resource(URI.create(u));
    }

    public WebResource resource(URI u) {
        return new WebResource(this, u);
    }

    public AsyncWebResource asyncResource(String u) {
        return this.asyncResource(URI.create(u));
    }

    public AsyncWebResource asyncResource(URI u) {
        return new AsyncWebResource(this, u);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setFollowRedirects(Boolean redirect) {
        this.getProperties().put("com.sun.jersey.client.property.followRedirects", redirect);
    }

    public void setReadTimeout(Integer interval) {
        this.getProperties().put("com.sun.jersey.client.property.readTimeout", interval);
    }

    public void setConnectTimeout(Integer interval) {
        this.getProperties().put("com.sun.jersey.client.property.connectTimeout", interval);
    }

    public void setChunkedEncodingSize(Integer chunkSize) {
        this.getProperties().put("com.sun.jersey.client.property.chunkedEncodingSize", chunkSize);
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        cr.getProperties().putAll(this.properties);
        return this.getHeadHandler().handle(cr);
    }

    public static Client create() {
        return new Client(Client.createDefaultClientHander());
    }

    public static Client create(ClientConfig cc) {
        return new Client(Client.createDefaultClientHander(), cc);
    }

    public static Client create(ClientConfig cc, IoCComponentProviderFactory provider) {
        return new Client(Client.createDefaultClientHander(), cc, provider);
    }

    private static ClientHandler createDefaultClientHander() {
        return new URLConnectionClientHandler();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }
}

