/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractImplicitViewMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.api.uri.UriPattern;
import com.sun.jersey.api.view.ImplicitProduces;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.header.QualitySourceMediaType;
import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.server.impl.component.ResourceFactory;
import com.sun.jersey.server.impl.container.filter.FilterFactory;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.server.impl.model.ResourceMethodMap;
import com.sun.jersey.server.impl.model.RulesMap;
import com.sun.jersey.server.impl.model.method.ResourceHeadWrapperMethod;
import com.sun.jersey.server.impl.model.method.ResourceHttpMethod;
import com.sun.jersey.server.impl.model.method.ResourceHttpOptionsMethod;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.impl.template.ViewResourceMethod;
import com.sun.jersey.server.impl.template.ViewableRule;
import com.sun.jersey.server.impl.uri.PathPattern;
import com.sun.jersey.server.impl.uri.PathTemplate;
import com.sun.jersey.server.impl.uri.rules.CombiningMatchingPatterns;
import com.sun.jersey.server.impl.uri.rules.HttpMethodRule;
import com.sun.jersey.server.impl.uri.rules.PatternRulePair;
import com.sun.jersey.server.impl.uri.rules.RightHandPathRule;
import com.sun.jersey.server.impl.uri.rules.SequentialMatchingPatterns;
import com.sun.jersey.server.impl.uri.rules.SubLocatorRule;
import com.sun.jersey.server.impl.uri.rules.TerminatingRule;
import com.sun.jersey.server.impl.uri.rules.UriRulesFactory;
import com.sun.jersey.server.impl.wadl.WadlFactory;
import com.sun.jersey.server.spi.component.ResourceComponentProvider;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceClass {
    private final UriRules<UriRule> rules;
    private final ResourceConfig config;
    private final WadlFactory wadlFactory;
    public final AbstractResource resource;
    public ResourceComponentProvider rcProvider;

    public ResourceClass(ResourceConfig config, ResourceMethodDispatcherFactory df, ServerInjectableProviderContext injectableContext, FilterFactory ff, WadlFactory wadlFactory, AbstractResource resource) {
        ImplicitProduces ip;
        this.resource = resource;
        this.config = config;
        this.wadlFactory = wadlFactory;
        boolean implicitViewables = config.getFeature("com.sun.jersey.config.feature.ImplicitViewables");
        List<QualitySourceMediaType> implictProduces = null;
        if (implicitViewables && (ip = resource.getAnnotation(ImplicitProduces.class)) != null && ip.value() != null && ip.value().length > 0) {
            implictProduces = MediaTypes.createQualitySourceMediaTypes(ip.value());
        }
        RulesMap<UriRule> rulesMap = new RulesMap<UriRule>();
        this.processSubResourceLocators(ff, injectableContext, rulesMap);
        Map<PathPattern, ResourceMethodMap> patternMethodMap = this.processSubResourceMethods(implictProduces, df, ff);
        ResourceMethodMap methodMap = this.processMethods(implictProduces, df, ff);
        for (Map.Entry<PathPattern, ResourceMethodMap> e : patternMethodMap.entrySet()) {
            PathPattern p = e.getKey();
            ResourceMethodMap rmm = e.getValue();
            rmm.sort();
            rulesMap.put(p, new RightHandPathRule(config.getFeature("com.sun.jersey.config.feature.Redirect"), p.getTemplate().endsWithSlash(), new HttpMethodRule(rmm, implictProduces, true)));
        }
        methodMap.sort();
        if (!methodMap.isEmpty()) {
            rulesMap.put(PathPattern.EMPTY_PATH, new HttpMethodRule(methodMap, implictProduces));
        }
        UriRules<UriRule> atomicRules = UriRulesFactory.create(rulesMap);
        ArrayList patterns = new ArrayList();
        if (config.getFeature("com.sun.jersey.config.feature.ImplicitViewables")) {
            AbstractImplicitViewMethod method = new AbstractImplicitViewMethod(resource);
            List<ResourceFilter> resourceFilters = ff.getResourceFilters(method);
            ViewableRule r = new ViewableRule(implictProduces, ff.getRequestFilters(resourceFilters), ff.getResponseFilters(resourceFilters));
            ComponentInjector<ViewableRule> ci = new ComponentInjector<ViewableRule>(injectableContext, ViewableRule.class);
            ci.inject(r);
            patterns.add(new PatternRulePair<ViewableRule>(new UriPattern("/([^/]+)"), r));
            patterns.add(new PatternRulePair<ViewableRule>(UriPattern.EMPTY, r));
        }
        patterns.add(new PatternRulePair<TerminatingRule>(new UriPattern(".*"), new TerminatingRule()));
        patterns.add(new PatternRulePair<TerminatingRule>(UriPattern.EMPTY, new TerminatingRule()));
        SequentialMatchingPatterns sequentialRules = new SequentialMatchingPatterns(patterns);
        CombiningMatchingPatterns<UriRule> combiningRules = new CombiningMatchingPatterns<UriRule>(Arrays.asList(atomicRules, sequentialRules));
        this.rules = combiningRules;
    }

    public void init(ResourceFactory rcpFactory) {
        this.rcProvider = rcpFactory.getComponentProvider(this.resource.getResourceClass());
        this.rcProvider.init(this.resource);
    }

    public void init(final Object resource) {
        this.rcProvider = new ResourceComponentProvider(){

            public void init(AbstractResource abstractResource) {
            }

            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            public Object getInstance(HttpContext hc) {
                return this.getInstance();
            }

            public void destroy() {
            }

            public Object getInstance() {
                return resource;
            }
        };
    }

    public void destroy() {
        this.rcProvider.destroy();
    }

    public UriRules<UriRule> getRules() {
        return this.rules;
    }

    private void addToPatternMethodMap(Map<PathPattern, ResourceMethodMap> tmm, PathPattern p, ResourceMethod rm) {
        ResourceMethodMap rmm = tmm.get(p);
        if (rmm == null) {
            rmm = new ResourceMethodMap();
            tmm.put(p, rmm);
        }
        rmm.put(rm);
    }

    private void processSubResourceLocators(FilterFactory ff, ServerInjectableProviderContext injectableContext, RulesMap<UriRule> rulesMap) {
        for (AbstractSubResourceLocator locator : this.resource.getSubResourceLocators()) {
            PathTemplate t = new PathTemplate(locator.getPath().getValue());
            PathPattern p = new PathPattern(t);
            List<ResourceFilter> resourceFilters = ff.getResourceFilters(locator);
            SubLocatorRule r = new SubLocatorRule(t, locator.getMethod(), injectableContext.getInjectable(locator.getParameters(), ComponentScope.PerRequest), ff.getRequestFilters(resourceFilters), ff.getResponseFilters(resourceFilters));
            rulesMap.put(p, new RightHandPathRule(this.config.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), r));
        }
    }

    private Map<PathPattern, ResourceMethodMap> processSubResourceMethods(List<QualitySourceMediaType> implictProduces, ResourceMethodDispatcherFactory df, FilterFactory ff) {
        HashMap<PathPattern, ResourceMethodMap> patternMethodMap = new HashMap<PathPattern, ResourceMethodMap>();
        for (AbstractSubResourceMethod abstractSubResourceMethod : this.resource.getSubResourceMethods()) {
            PathTemplate t = new PathTemplate(abstractSubResourceMethod.getPath().getValue());
            PathPattern p = new PathPattern(t, "(/)?");
            ResourceHttpMethod rm = new ResourceHttpMethod(df, ff, t, abstractSubResourceMethod);
            this.addToPatternMethodMap(patternMethodMap, p, rm);
        }
        for (Map.Entry entry : patternMethodMap.entrySet()) {
            List getList;
            if (implictProduces != null && (getList = (List)((ResourceMethodMap)entry.getValue()).get("GET")) != null && !getList.isEmpty()) {
                ((ResourceMethodMap)entry.getValue()).put(new ViewResourceMethod(implictProduces));
            }
            this.processHead((ResourceMethodMap)entry.getValue());
            this.processOptions((ResourceMethodMap)entry.getValue(), this.resource, (PathPattern)entry.getKey());
        }
        return patternMethodMap;
    }

    private ResourceMethodMap processMethods(List<QualitySourceMediaType> implictProduces, ResourceMethodDispatcherFactory df, FilterFactory ff) {
        List getList;
        ResourceMethodMap methodMap = new ResourceMethodMap();
        for (AbstractResourceMethod resourceMethod : this.resource.getResourceMethods()) {
            ResourceHttpMethod rm = new ResourceHttpMethod(df, ff, resourceMethod);
            methodMap.put(rm);
        }
        if (implictProduces != null && (getList = (List)methodMap.get("GET")) != null && !getList.isEmpty()) {
            methodMap.put(new ViewResourceMethod(implictProduces));
        }
        this.processHead(methodMap);
        this.processOptions(methodMap, this.resource, null);
        return methodMap;
    }

    private void processHead(ResourceMethodMap methodMap) {
        List getList = (List)methodMap.get("GET");
        if (getList == null || getList.isEmpty()) {
            return;
        }
        List<ResourceMethod> headList = (ArrayList<ResourceMethod>)methodMap.get("HEAD");
        if (headList == null) {
            headList = new ArrayList<ResourceMethod>();
        }
        for (ResourceMethod getMethod : getList) {
            if (this.containsMediaOfMethod(headList, getMethod)) continue;
            ResourceHeadWrapperMethod headMethod = new ResourceHeadWrapperMethod(getMethod);
            methodMap.put(headMethod);
            headList = (List)methodMap.get("HEAD");
        }
    }

    private boolean containsMediaOfMethod(List<ResourceMethod> methods, ResourceMethod method) {
        for (ResourceMethod m : methods) {
            if (!method.mediaEquals(m)) continue;
            return true;
        }
        return false;
    }

    private void processOptions(ResourceMethodMap methodMap, AbstractResource resource, PathPattern p) {
        List l = (List)methodMap.get("OPTIONS");
        if (l != null) {
            return;
        }
        ResourceMethod optionsMethod = this.wadlFactory.createWadlOptionsMethod(methodMap, resource, p);
        if (optionsMethod == null) {
            optionsMethod = new ResourceHttpOptionsMethod(methodMap);
        }
        methodMap.put(optionsMethod);
    }
}

