/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.model.method.dispatch;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.impl.ResponseBuilderImpl;
import com.sun.jersey.impl.model.ReflectionHelper;
import com.sun.jersey.impl.model.method.dispatch.ResourceJavaMethodDispatcher;
import com.sun.jersey.impl.model.method.dispatch.ResourceMethodDispatchProvider;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityParamDispatchProvider
implements ResourceMethodDispatchProvider {
    @Context
    InjectableProviderContext ipc;

    @Override
    public RequestDispatcher create(AbstractResourceMethod abstractResourceMethod) {
        List<Injectable> is;
        boolean requireReturnOfRepresentation = false;
        boolean requireNoEntityParameter = false;
        if ("GET".equals(abstractResourceMethod.getHttpMethod())) {
            requireReturnOfRepresentation = true;
            requireNoEntityParameter = true;
        }
        if ((is = this.processParameters(abstractResourceMethod, requireNoEntityParameter)) == null) {
            return null;
        }
        Class<?> returnType = abstractResourceMethod.getMethod().getReturnType();
        if (Response.class.isAssignableFrom(returnType)) {
            return new ResponseOutInvoker(abstractResourceMethod, is);
        }
        if (returnType != Void.TYPE) {
            if (returnType == Object.class || GenericEntity.class.isAssignableFrom(returnType)) {
                return new ObjectOutInvoker(abstractResourceMethod, is);
            }
            return new TypeOutInvoker(abstractResourceMethod, is);
        }
        if (requireReturnOfRepresentation) {
            return null;
        }
        return new VoidOutInvoker(abstractResourceMethod, is);
    }

    private List<Injectable> processParameters(AbstractResourceMethod method, boolean requireNoEntityParameter) {
        if (null == method.getParameters() || 0 == method.getParameters().size()) {
            return Collections.emptyList();
        }
        ArrayList<Injectable> is = new ArrayList<Injectable>(method.getParameters().size());
        for (int i = 0; i < method.getParameters().size(); ++i) {
            Injectable injectable = this.processParameter(method, method.getParameters().get(i), method.getMethod().getParameterAnnotations()[i], requireNoEntityParameter);
            if (injectable == null) {
                return null;
            }
            is.add(injectable);
        }
        return is;
    }

    private Injectable processParameter(AbstractResourceMethod method, Parameter parameter, Annotation[] annotations, boolean requireNoEntityParameter) {
        if (Parameter.Source.ENTITY == parameter.getSource()) {
            if (requireNoEntityParameter) {
                return null;
            }
            if (parameter.getParameterType() instanceof TypeVariable) {
                ReflectionHelper.ClassTypePair ct = ReflectionHelper.resolveTypeVariable(method.getDeclaringResource().getResourceClass(), method.getMethod().getDeclaringClass(), (TypeVariable)parameter.getParameterType());
                return ct != null ? new EntityInjectable(ct.c, ct.t, annotations) : null;
            }
            return new EntityInjectable(parameter.getParameterClass(), parameter.getParameterType(), annotations);
        }
        Injectable i = this.ipc.getInjectable(parameter, ComponentProvider.Scope.PerRequest);
        return i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObjectOutInvoker
    extends EntityParamInInvoker {
        ObjectOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            Object o = this.method.invoke(resource, params);
            MediaType mediaType = this.getAcceptableMediaType(context.getRequest());
            if (o instanceof Response) {
                Response r = (Response)o;
                context.getResponse().setResponse(r, mediaType);
            } else if (o != null) {
                Response r = new ResponseBuilderImpl().status(200).entity(o).type(mediaType).build();
                context.getResponse().setResponse(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ResponseOutInvoker
    extends EntityParamInInvoker {
        ResponseOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            Response r = (Response)this.method.invoke(resource, params);
            if (r != null) {
                MediaType mediaType = this.getAcceptableMediaType(context.getRequest());
                context.getResponse().setResponse(r, mediaType);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TypeOutInvoker
    extends EntityParamInInvoker {
        private final Type t;

        TypeOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
            this.t = abstractResourceMethod.getMethod().getGenericReturnType();
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            Object o = this.method.invoke(resource, params);
            if (o != null) {
                MediaType mediaType = this.getAcceptableMediaType(context.getRequest());
                Response r = new ResponseBuilderImpl().entityWithType(o, this.t).type(mediaType).status(200).build();
                context.getResponse().setResponse(r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class VoidOutInvoker
    extends EntityParamInInvoker {
        VoidOutInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod, is);
        }

        @Override
        public void _dispatch(Object resource, HttpContext context) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(context);
            this.method.invoke(resource, params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class EntityParamInInvoker
    extends ResourceJavaMethodDispatcher {
        private final List<Injectable> is;

        EntityParamInInvoker(AbstractResourceMethod abstractResourceMethod, List<Injectable> is) {
            super(abstractResourceMethod);
            this.is = is;
        }

        protected final Object[] getParams(HttpContext context) {
            Object[] params = new Object[this.is.size()];
            try {
                int index = 0;
                for (Injectable i : this.is) {
                    params[index++] = i.getValue(context);
                }
                return params;
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ContainerException("Exception injecting parameters to Web resource method", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EntityInjectable
    implements Injectable<Object> {
        final Class<?> c;
        final Type t;
        final Annotation[] as;

        EntityInjectable(Class c, Type t, Annotation[] as) {
            this.c = c;
            this.t = t;
            this.as = as;
        }

        @Override
        public Object getValue(HttpContext context) {
            return context.getRequest().getEntity(this.c, this.t, this.as);
        }
    }
}

