/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.provider.jaxb;

import com.sun.jersey.core.provider.AbstractMessageReaderWriterProvider;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider<T>
extends AbstractMessageReaderWriterProvider<T> {
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    private final Providers ps;
    private final boolean fixedMediaType;
    private final ContextResolver<JAXBContext> context;
    private final ContextResolver<Unmarshaller> unmarshaller;
    private final ContextResolver<Marshaller> marshaller;
    private final ContextResolver<JAXBContext> mtContext;
    private final ContextResolver<Unmarshaller> mtUnmarshaller;
    private final ContextResolver<Marshaller> mtMarshaller;

    public AbstractJAXBProvider(Providers ps) {
        this(ps, null);
    }

    public AbstractJAXBProvider(Providers ps, MediaType mt) {
        this.ps = ps;
        this.context = ps.getContextResolver(JAXBContext.class, null);
        this.unmarshaller = ps.getContextResolver(Unmarshaller.class, null);
        this.marshaller = ps.getContextResolver(Marshaller.class, null);
        boolean bl = this.fixedMediaType = mt != null;
        if (mt != null) {
            this.mtContext = ps.getContextResolver(JAXBContext.class, mt);
            this.mtUnmarshaller = ps.getContextResolver(Unmarshaller.class, mt);
            this.mtMarshaller = ps.getContextResolver(Marshaller.class, mt);
        } else {
            this.mtContext = null;
            this.mtUnmarshaller = null;
            this.mtMarshaller = null;
        }
    }

    protected boolean isSupported(MediaType m) {
        return true;
    }

    protected final Unmarshaller getUnmarshaller(Class type, MediaType mt) throws JAXBException {
        Unmarshaller u;
        if (this.fixedMediaType) {
            return this.getUnmarshaller(type);
        }
        ContextResolver uncr = this.ps.getContextResolver(Unmarshaller.class, mt);
        if (uncr != null && (u = (Unmarshaller)uncr.getContext(type)) != null) {
            return u;
        }
        if (this.unmarshaller != null && (u = (Unmarshaller)this.unmarshaller.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type, mt).createUnmarshaller();
    }

    protected final Unmarshaller getUnmarshaller(Class type) throws JAXBException {
        Unmarshaller u;
        if (this.mtUnmarshaller != null && (u = (Unmarshaller)this.mtUnmarshaller.getContext(type)) != null) {
            return u;
        }
        if (this.unmarshaller != null && (u = (Unmarshaller)this.unmarshaller.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type).createUnmarshaller();
    }

    protected final Marshaller getMarshaller(Class type, MediaType mt) throws JAXBException {
        Marshaller u;
        if (this.fixedMediaType) {
            return this.getMarshaller(type);
        }
        ContextResolver mcr = this.ps.getContextResolver(Marshaller.class, mt);
        if (mcr != null && (u = (Marshaller)mcr.getContext(type)) != null) {
            return u;
        }
        if (this.marshaller != null && (u = (Marshaller)this.marshaller.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type, mt).createMarshaller();
    }

    protected final Marshaller getMarshaller(Class type) throws JAXBException {
        Marshaller u;
        if (this.mtMarshaller != null && (u = (Marshaller)this.mtMarshaller.getContext(type)) != null) {
            return u;
        }
        if (this.marshaller != null && (u = (Marshaller)this.marshaller.getContext(type)) != null) {
            return u;
        }
        return this.getJAXBContext(type).createMarshaller();
    }

    private final JAXBContext getJAXBContext(Class type) throws JAXBException {
        JAXBContext c;
        if (this.mtContext != null && (c = (JAXBContext)this.mtContext.getContext(type)) != null) {
            return c;
        }
        if (this.context != null && (c = (JAXBContext)this.context.getContext(type)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type);
    }

    private final JAXBContext getJAXBContext(Class type, MediaType mt) throws JAXBException {
        JAXBContext c;
        ContextResolver cr = this.ps.getContextResolver(JAXBContext.class, mt);
        if (cr != null && (c = (JAXBContext)cr.getContext(type)) != null) {
            return c;
        }
        if (this.context != null && (c = (JAXBContext)this.context.getContext(type)) != null) {
            return c;
        }
        return this.getStoredJAXBContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getStoredJAXBContext(Class type) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext c = jaxbContexts.get(type);
            if (c == null) {
                c = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, c);
            }
            return c;
        }
    }
}

