/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.provider.jaxb;

import com.sun.jersey.core.provider.jaxb.AbstractJAXBProvider;
import com.sun.jersey.core.util.ThrowHelper;
import com.sun.jersey.impl.ImplMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRootElementProvider
extends AbstractJAXBProvider<Object> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRootElementProvider.class);

    public AbstractRootElementProvider(Providers ps) {
        super(ps);
    }

    public AbstractRootElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return (type.getAnnotation(XmlRootElement.class) != null || type.getAnnotation(XmlType.class) != null) && this.isSupported(mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean found;
        Class<XmlRootElement> targetClass = XmlRootElement.class;
        boolean bl = found = type.getAnnotation(targetClass) != null && this.isSupported(mediaType);
        if (!found && log.isDebugEnabled()) {
            Annotation[] annotations1;
            log.debug("Target class class loader : " + targetClass.getClassLoader());
            log.debug("Target class protection domain : " + targetClass.getProtectionDomain());
            for (Annotation annotation : annotations1 = type.getAnnotations()) {
                log.debug("Annotation : " + ((Object)annotation).toString());
                log.debug("Target class class loader : " + annotation.getClass().getClassLoader());
                log.debug("Target class protection domain : " + annotation.getClass().getProtectionDomain());
            }
        }
        return found;
    }

    public final Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return this.readFrom(type, mediaType, this.getUnmarshaller(type, mediaType), entityStream);
        }
        catch (UnmarshalException ex) {
            throw new WebApplicationException((Throwable)ex, 400);
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_UNMARSHALLING_JAXB(type)));
        }
    }

    protected Object readFrom(Class<Object> type, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws JAXBException, IOException {
        if (type.isAnnotationPresent(XmlRootElement.class)) {
            return u.unmarshal(entityStream);
        }
        return u.unmarshal((Source)new StreamSource(entityStream), type).getValue();
    }

    public final void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Marshaller m = this.getMarshaller(type, mediaType);
            Charset c = AbstractRootElementProvider.getCharset(mediaType);
            if (c != UTF8) {
                m.setProperty("jaxb.encoding", (Object)c.name());
            }
            this.writeTo(t, mediaType, c, m, entityStream);
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(t.getClass())));
        }
    }

    protected void writeTo(Object t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException, IOException {
        m.marshal(t, entityStream);
    }
}

