/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.uri.rules;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.HttpResponseContext;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.header.QualitySourceMediaType;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.impl.template.ViewResourceMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpMethodRule
implements UriRule {
    private final Map<String, List<ResourceMethod>> map;
    private final List<QualitySourceMediaType> priorityMediaTypes;
    private final String allow;
    private final boolean isSubResource;

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods, List<QualitySourceMediaType> priorityMediaTypes) {
        this(methods, priorityMediaTypes, false);
    }

    public HttpMethodRule(Map<String, List<ResourceMethod>> methods, List<QualitySourceMediaType> priorityMediaTypes, boolean isSubResource) {
        this.map = methods;
        this.priorityMediaTypes = priorityMediaTypes;
        this.isSubResource = isSubResource;
        this.allow = this.getAllow(methods);
    }

    private String getAllow(Map<String, List<ResourceMethod>> methods) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (String method : methods.keySet()) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(method);
        }
        return s.toString();
    }

    @Override
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        if (path.length() > 0) {
            return false;
        }
        HttpRequestContext request = context.getRequest();
        HttpResponseContext response = context.getResponse();
        List<ResourceMethod> methods = this.map.get(request.getMethod());
        if (methods == null) {
            response.setResponse(Responses.methodNotAllowed().header("Allow", (Object)this.allow).build());
            return false;
        }
        List<MediaType> accept = this.priorityMediaTypes == null ? request.getAcceptableMediaTypes() : request.getAcceptableMediaTypes(this.priorityMediaTypes);
        Matcher m = new Matcher();
        MatchStatus s = m.match(methods, request.getMediaType(), accept);
        if (s == MatchStatus.MATCH) {
            ResourceMethod method = m.rmSelected;
            if (method instanceof ViewResourceMethod) {
                return false;
            }
            if (this.isSubResource) {
                context.pushResource(resource);
                context.pushMatch(method.getTemplate(), method.getTemplate().getTemplateVariables());
            }
            context.pushContainerResponseFilters(method.getResponseFilters());
            if (!method.getRequestFilters().isEmpty()) {
                ContainerRequest containerRequest = context.getContainerRequest();
                for (ContainerRequestFilter f : method.getRequestFilters()) {
                    containerRequest = f.filter(containerRequest);
                    context.setContainerRequest(containerRequest);
                }
            }
            method.getDispatcher().dispatch(resource, context);
            Object contentType = response.getHttpHeaders().getFirst((Object)"Content-Type");
            if (contentType == null && m.rmSelected.isProducesDeclared() && !m.mSelected.isWildcardType() && !m.mSelected.isWildcardSubtype()) {
                response.getHttpHeaders().putSingle((Object)"Content-Type", (Object)m.mSelected);
            }
            return true;
        }
        if (s == MatchStatus.NO_MATCH_FOR_CONSUME) {
            response.setResponse(Responses.unsupportedMediaType().build());
            return false;
        }
        if (s == MatchStatus.NO_MATCH_FOR_PRODUCE) {
            response.setResponse(Responses.notAcceptable().build());
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Matcher
    extends LinkedList<ResourceMethod> {
        private MediaType mSelected = null;
        private ResourceMethod rmSelected = null;

        private Matcher() {
        }

        private MatchStatus match(List<ResourceMethod> methods, MediaType contentType, List<MediaType> acceptableMediaTypes) {
            Matcher selected = null;
            if (contentType != null) {
                for (ResourceMethod method : methods) {
                    if (!method.consumes(contentType)) continue;
                    this.add(method);
                }
                if (this.isEmpty()) {
                    return MatchStatus.NO_MATCH_FOR_CONSUME;
                }
                selected = this;
            } else {
                selected = methods;
            }
            for (MediaType amt : acceptableMediaTypes) {
                for (ResourceMethod rm : selected) {
                    for (MediaType p : rm.getProduces()) {
                        if (!p.isCompatible(amt)) continue;
                        this.mSelected = MediaTypes.mostSpecific(p, amt);
                        this.rmSelected = rm;
                        return MatchStatus.MATCH;
                    }
                }
            }
            return MatchStatus.NO_MATCH_FOR_PRODUCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchStatus {
        MATCH,
        NO_MATCH_FOR_CONSUME,
        NO_MATCH_FOR_PRODUCE;

    }
}

