/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponse {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    protected static final RuntimeDelegate.HeaderDelegate<EntityTag> entityTagDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class);
    protected static final RuntimeDelegate.HeaderDelegate<Date> dateDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(Date.class);
    private Map<String, Object> properties;
    private int status;
    private InBoundHeaders headers;
    private InputStream entity;
    private MessageBodyWorkers workers;

    public ClientResponse(int status, InBoundHeaders headers, InputStream entity, MessageBodyWorkers workers) {
        this.status = status;
        this.headers = headers;
        this.entity = entity;
        this.workers = workers;
    }

    public Map<String, Object> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = new HashMap<String, Object>();
        return this.properties;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Response.Status getResponseStatus() {
        return Response.Status.fromStatusCode((int)this.status);
    }

    public void setResponseStatus(Response.Status status) {
        this.setStatus(status.getStatusCode());
    }

    public MultivaluedMap<String, String> getMetadata() {
        return this.headers;
    }

    public boolean hasEntity() {
        try {
            return this.entity.available() > 0;
        }
        catch (IOException ex) {
            throw new ClientHandlerException(ex);
        }
    }

    public InputStream getEntityInputStream() {
        return this.entity;
    }

    public void setEntityInputStream(InputStream entity) {
        this.entity = entity;
    }

    public <T> T getEntity(Class<T> c) throws IllegalArgumentException, UniformInterfaceException {
        return this.getEntity(c, c);
    }

    public <T> T getEntity(GenericType<T> gt) throws IllegalArgumentException, UniformInterfaceException {
        return this.getEntity(gt.getRawClass(), gt.getType());
    }

    private <T> T getEntity(Class<T> c, Type type) {
        if (this.getStatus() == 204) {
            throw new UniformInterfaceException(this);
        }
        try {
            MessageBodyReader<T> br;
            MediaType mediaType = this.getType();
            if (mediaType == null) {
                mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
            if ((br = this.workers.getMessageBodyReader(c, type, EMPTY_ANNOTATIONS, mediaType)) == null) {
                throw new ClientHandlerException("A message body reader for Java type, " + c + ", and MIME media type, " + mediaType + ", was not found");
            }
            Object t = br.readFrom(c, type, EMPTY_ANNOTATIONS, mediaType, (MultivaluedMap)this.headers, this.entity);
            if (!(t instanceof Closeable)) {
                this.entity.close();
            }
            this.entity = null;
            return (T)t;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public MediaType getType() {
        String ct = (String)this.getMetadata().getFirst((Object)"Content-Type");
        return ct != null ? MediaType.valueOf((String)ct) : null;
    }

    public URI getLocation() {
        String l = (String)this.getMetadata().getFirst((Object)"Location");
        return l != null ? URI.create(l) : null;
    }

    public EntityTag getEntityTag() {
        String t = (String)this.getMetadata().getFirst((Object)"ETag");
        return t != null ? (EntityTag)entityTagDelegate.fromString(t) : null;
    }

    public Date getLastModified() {
        String d = (String)this.getMetadata().getFirst((Object)"Last-Modified");
        return d != null ? (Date)dateDelegate.fromString(d) : null;
    }

    public Date getResponseDate() {
        String d = (String)this.getMetadata().getFirst((Object)"Date");
        return d != null ? (Date)dateDelegate.fromString(d) : null;
    }

    public String getLanguage() {
        return (String)this.getMetadata().getFirst((Object)"Content-Language");
    }

    public List<NewCookie> getCookies() {
        List hs = (List)this.getMetadata().get((Object)"Set-Cookie");
        if (hs == null) {
            return Collections.emptyList();
        }
        ArrayList<NewCookie> cs = new ArrayList<NewCookie>();
        for (String h : hs) {
            cs.add(NewCookie.valueOf((String)h));
        }
        return cs;
    }

    public String toString() {
        return "Client response status: " + this.status;
    }
}

