/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container.servlet;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.ApplicationAdapter;
import com.sun.jersey.api.core.ClasspathResourceConfig;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.server.impl.container.servlet.JSPTemplateProcessor;
import com.sun.jersey.server.impl.container.servlet.ServletContainerRequest;
import com.sun.jersey.server.impl.container.servlet.ThreadLocalInvoker;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerNotifier;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.WebApplicationFactory;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainer
extends HttpServlet
implements ContainerListener {
    public static final String APPLICATION_CONFIG_CLASS = "javax.ws.rs.Application";
    public static final String RESOURCE_CONFIG_CLASS = "com.sun.jersey.config.property.resourceConfigClass";
    public static final String JSP_TEMPLATES_BASE_PATH = "com.sun.jersey.config.property.JSPTemplatesBasePath";
    private static final Logger LOGGER = Logger.getLogger(ServletContainer.class.getName());
    private final ThreadLocalInvoker<HttpServletRequest> requestInvoker = new ThreadLocalInvoker();
    private final ThreadLocalInvoker<HttpServletResponse> responseInvoker = new ThreadLocalInvoker();
    private ServletConfig config;
    private ServletContext context;
    private ResourceConfig resourceConfig;
    private WebApplication application;

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.config = servletConfig;
        this.context = this.config.getServletContext();
        this.resourceConfig = this.createResourceConfig(this.config);
        this.initResourceConfigFeatures(servletConfig, this.resourceConfig);
        this.load();
        Object o = this.resourceConfig.getProperties().get("com.sun.jersey.spi.container.ContainerNotifier");
        if (o instanceof ContainerNotifier) {
            ContainerNotifier crf = (ContainerNotifier)o;
            crf.addListener(this);
        }
    }

    public void destroy() {
        this.application.destroy();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encodedBasePath;
        if (request.getPathInfo() != null && request.getPathInfo().equals("/") && !request.getRequestURI().endsWith("/")) {
            response.setStatus(404);
            return;
        }
        WebApplication _application = this.application;
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString());
        String decodedBasePath = request.getPathInfo() != null ? request.getContextPath() + request.getServletPath() + "/" : request.getContextPath() + "/";
        if (!decodedBasePath.equals(encodedBasePath = UriComponent.encode(decodedBasePath, UriComponent.Type.PATH))) {
            throw new ContainerException("The servlet context path and/or the servlet path contain characters that are percent enocded");
        }
        URI baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
        String queryParameters = request.getQueryString();
        if (queryParameters == null) {
            queryParameters = "";
        }
        URI requestUri = absoluteUriBuilder.replacePath(request.getRequestURI()).replaceQuery(queryParameters).build(new Object[0]);
        ServletContainerRequest cRequest = new ServletContainerRequest(request, _application, request.getMethod(), baseUri, requestUri, this.getHeaders(request), (InputStream)request.getInputStream());
        try {
            this.requestInvoker.set(request);
            this.responseInvoker.set(response);
            _application.handleRequest((ContainerRequest)cRequest, new Writer(response));
        }
        catch (ContainerException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            this.requestInvoker.set(null);
            this.responseInvoker.set(null);
        }
    }

    private InBoundHeaders getHeaders(HttpServletRequest request) {
        InBoundHeaders rh = new InBoundHeaders();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            LinkedList valueList = new LinkedList();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                valueList.add(values.nextElement());
            }
            rh.put(name, valueList);
        }
        return rh;
    }

    private ResourceConfig createResourceConfig(ServletConfig servletConfig) throws ServletException {
        Map<String, Object> props = this.getInitParams(servletConfig);
        String resourceConfigClassName = servletConfig.getInitParameter(RESOURCE_CONFIG_CLASS);
        if (resourceConfigClassName == null) {
            resourceConfigClassName = servletConfig.getInitParameter(APPLICATION_CONFIG_CLASS);
        }
        if (resourceConfigClassName == null) {
            String packages = servletConfig.getInitParameter("com.sun.jersey.config.property.packages");
            if (packages != null) {
                props.put("com.sun.jersey.config.property.packages", packages);
                return new PackagesResourceConfig(props);
            }
            return this.getDefaultResourceConfig(props, servletConfig);
        }
        try {
            Class<?> resourceConfigClass = this.getClassLoader().loadClass(resourceConfigClassName);
            if (resourceConfigClass == ClasspathResourceConfig.class) {
                String[] paths = this.getPaths(servletConfig.getInitParameter("com.sun.jersey.config.property.classpath"));
                props.put("com.sun.jersey.config.property.classpath", paths);
                return new ClasspathResourceConfig(props);
            }
            if (ResourceConfig.class.isAssignableFrom(resourceConfigClass)) {
                try {
                    Constructor<?> constructor = resourceConfigClass.getConstructor(Map.class);
                    if (ClasspathResourceConfig.class.isAssignableFrom(resourceConfigClass)) {
                        String[] paths = this.getPaths(servletConfig.getInitParameter("com.sun.jersey.config.property.classpath"));
                        props.put("com.sun.jersey.config.property.classpath", paths);
                    }
                    return (ResourceConfig)((Object)constructor.newInstance(props));
                }
                catch (NoSuchMethodException ex) {
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                try {
                    return (ResourceConfig)((Object)resourceConfigClass.newInstance());
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (Application.class.isAssignableFrom(resourceConfigClass)) {
                try {
                    ApplicationAdapter rc = new ApplicationAdapter((Application)resourceConfigClass.newInstance());
                    ((ResourceConfig)rc).getProperties().putAll(props);
                    return rc;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            String message = "Resource configuration class, " + resourceConfigClassName + ", is not a super class of " + ResourceConfig.class;
            throw new ServletException(message);
        }
        catch (ClassNotFoundException e) {
            String message = "Resource configuration class, " + resourceConfigClassName + ", could not be loaded";
            throw new ServletException(message, (Throwable)e);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    private Map<String, Object> getInitParams(ServletConfig servletConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = servletConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, servletConfig.getInitParameter(name));
        }
        return props;
    }

    private String[] getPaths(String classpath) throws ServletException {
        if (classpath == null) {
            String[] paths = new String[]{this.context.getRealPath("/WEB-INF/lib"), this.context.getRealPath("/WEB-INF/classes")};
            if (paths[0] == null && paths[1] == null) {
                String message = "The default deployment configuration that scans for classes in /WEB-INF/lib and /WEB-INF/classes is not supported for the application server.Try using the package scanning configuration, see the JavaDoc for " + PackagesResourceConfig.class.getName() + " and the property " + "com.sun.jersey.config.property.packages" + ".";
                throw new ServletException(message);
            }
            return paths;
        }
        String[] virtualPaths = classpath.split(";");
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (String virtualPath : virtualPaths) {
            String path;
            if ((virtualPath = virtualPath.trim()).length() == 0 || (path = this.context.getRealPath(virtualPath)) == null) continue;
            resourcePaths.add(path);
        }
        if (resourcePaths.isEmpty()) {
            String message = "None of the declared classpath locations, " + classpath + ", could be resolved. " + "This could be because the default deployment configuration that scans for " + "classes in classpath locations is not supported. " + "Try using the package scanning configuration, see the JavaDoc for " + PackagesResourceConfig.class.getName() + " and the property " + "com.sun.jersey.config.property.packages" + ".";
            throw new ServletException(message);
        }
        return resourcePaths.toArray(new String[resourcePaths.size()]);
    }

    private void initResourceConfigFeatures(ServletConfig servletConfig, ResourceConfig rc) {
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.jersey.config.feature.CanonicalizeURIPath");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.jersey.config.feature.IgnoreMatrixParams");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.jersey.config.feature.NormalizeURI");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.jersey.config.feature.Redirect");
        this.setResourceConfigFeature(servletConfig, rc, "com.sun.jersey.config.feature.ImplicitViewables");
    }

    private void setResourceConfigFeature(ServletConfig servletConfig, ResourceConfig rc, String feature) {
        String value = servletConfig.getInitParameter(feature);
        if (value != null) {
            rc.getFeatures().put(feature, Boolean.valueOf(value));
        }
    }

    public final void load() {
        WebApplication _application = this.create();
        this.configure(this.config, this.resourceConfig, _application);
        this.initiate(this.resourceConfig, _application);
        this.application = _application;
    }

    public final void reload() {
        WebApplication _application = this.create();
        this.initiate(this.resourceConfig, _application);
        this.application = _application;
    }

    protected WebApplication create() {
        return WebApplicationFactory.createWebApplication();
    }

    protected void configure(ServletConfig sc, ResourceConfig rc, WebApplication wa) {
        rc.getSingletons().add(new ContextInjectableProvider<HttpServletRequest>((Type)((Object)HttpServletRequest.class), (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, this.requestInvoker)));
        rc.getSingletons().add(new ContextInjectableProvider<HttpServletResponse>((Type)((Object)HttpServletResponse.class), (HttpServletResponse)Proxy.newProxyInstance(HttpServletResponse.class.getClassLoader(), new Class[]{HttpServletResponse.class}, this.responseInvoker)));
        rc.getSingletons().add(new ContextInjectableProvider<ServletConfig>((Type)((Object)ServletConfig.class), sc));
        rc.getSingletons().add(new ContextInjectableProvider<ServletContext>((Type)((Object)ServletContext.class), sc.getServletContext()));
        rc.getSingletons().add(new JSPTemplateProcessor(this.resourceConfig, this.requestInvoker.getThreadLocal(), this.responseInvoker.getThreadLocal()));
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        this.validate(rc);
        wa.initiate(rc);
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, ServletConfig servletConfig) throws ServletException {
        String[] paths = this.getPaths(servletConfig.getInitParameter("com.sun.jersey.config.property.classpath"));
        props.put("com.sun.jersey.config.property.classpath", paths);
        return new ClasspathResourceConfig(props);
    }

    private void validate(ResourceConfig rc) {
        javax.naming.Context x = this.getContext();
        if (this.context != null) {
            Iterator i = rc.getClasses().iterator();
            while (i.hasNext()) {
                Class c = (Class)i.next();
                if (!c.isInterface()) continue;
                try {
                    Object o = x.lookup(c.getName());
                    if (o == null) continue;
                    i.remove();
                    rc.getSingletons().add(o);
                    LOGGER.log(Level.CONFIG, "An instance of the class " + c.getName() + " is found by JNDI look up using the class name as the JNDI name. " + "The instance will be registered as a singleton.");
                }
                catch (NamingException ex) {}
            }
        }
    }

    private javax.naming.Context getContext() {
        try {
            return new InitialContext();
        }
        catch (NamingException ex) {
            return null;
        }
    }

    @Override
    public void onReload() {
        this.reload();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }

    private static final class Writer
    extends OutputStream
    implements ContainerResponseWriter {
        final HttpServletResponse response;
        OutputStream out;

        Writer(HttpServletResponse response) {
            this.response = response;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse cResponse) throws IOException {
            this.response.setStatus(cResponse.getStatus());
            if (contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            MultivaluedMap<String, Object> headers = cResponse.getHttpHeaders();
            for (Map.Entry e : headers.entrySet()) {
                for (Object v : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), ContainerResponse.getHeaderValue(v));
                }
            }
            return this;
        }

        public void finish() throws IOException {
        }

        public void write(int b) throws IOException {
            this.initiate();
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.initiate();
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.initiate();
            this.out.write(b, off, len);
        }

        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        public void close() throws IOException {
            this.initiate();
            this.out.close();
        }

        void initiate() throws IOException {
            if (this.out == null) {
                this.out = this.response.getOutputStream();
            }
        }
    }
}

