/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.wadl;

import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.impl.wadl.WadlBuilder;
import com.sun.jersey.impl.wadl.WadlGenerator;
import com.sun.research.ws.wadl.Application;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/vnd.sun.wadl+xml", "application/xml"})
public final class WadlResource {
    private static final Logger LOGGER = Logger.getLogger(WadlResource.class.getName());
    private Application _a;
    private String _requiredJaxbContextPath;
    private byte[] _bytes;

    public WadlResource(Set<AbstractResource> rootResources, WadlGenerator wadlGenerator) {
        this._a = new WadlBuilder(wadlGenerator).generate(rootResources);
        this._requiredJaxbContextPath = wadlGenerator.getRequiredJaxbContextPath();
    }

    @GET
    public synchronized Response getWadl(@Context UriInfo uriInfo) {
        if (this._bytes == null) {
            if (this._a.getResources().getBase() == null) {
                this._a.getResources().setBase(uriInfo.getBaseUri().toString());
            }
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)this._requiredJaxbContextPath, (ClassLoader)this.getClass().getClassLoader());
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                marshaller.marshal((Object)this._a, (OutputStream)os);
                this._bytes = os.toByteArray();
                os.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not marshal wadl Application.", e);
                return Response.ok((Object)this._a).build();
            }
        }
        return Response.ok((Object)new ByteArrayInputStream(this._bytes)).build();
    }
}

