/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri.rules;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.impl.uri.rules.BaseRule;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubLocatorRule
extends BaseRule {
    private final List<Injectable> is;
    private final Method m;

    public SubLocatorRule(UriTemplate template, Method m, List<Injectable> is) {
        super(template);
        this.m = m;
        this.is = is;
    }

    @Override
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        this.setTemplateValues(context);
        resource = this.invokeSubLocator(resource, context);
        if (resource instanceof Class) {
            resource = context.getResource((Class)resource);
        }
        context.pushResource(resource, this.getTemplate());
        Iterator<UriRule> matches = context.getRules(resource.getClass()).match(path, context.getGroupValues());
        while (matches.hasNext()) {
            if (!matches.next().accept(path, resource, context)) continue;
            return true;
        }
        return false;
    }

    private Object invokeSubLocator(Object resource, UriRuleContext context) {
        try {
            if (this.is.size() == 0) {
                return this.m.invoke(resource, new Object[0]);
            }
            Object[] params = new Object[this.is.size()];
            int index = 0;
            for (Injectable i : this.is) {
                params[index++] = i.getValue(context);
            }
            return this.m.invoke(resource, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ContainerException(t);
        }
        catch (IllegalAccessException e) {
            throw new ContainerException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ContainerException("Exception injecting parameters to dynamic resolving method", e);
        }
    }
}

