/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.model;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.AbstractSubResourceLocator;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.api.uri.UriPattern;
import com.sun.jersey.impl.application.ResourceMethodDispatcherFactory;
import com.sun.jersey.impl.model.ResourceMethodMap;
import com.sun.jersey.impl.model.RulesMap;
import com.sun.jersey.impl.model.method.ResourceHeadWrapperMethod;
import com.sun.jersey.impl.model.method.ResourceHttpMethod;
import com.sun.jersey.impl.model.method.ResourceHttpOptionsMethod;
import com.sun.jersey.impl.model.method.ResourceMethod;
import com.sun.jersey.impl.template.ViewableRule;
import com.sun.jersey.impl.uri.PathPattern;
import com.sun.jersey.impl.uri.PathTemplate;
import com.sun.jersey.impl.uri.rules.CombiningMatchingPatterns;
import com.sun.jersey.impl.uri.rules.HttpMethodRule;
import com.sun.jersey.impl.uri.rules.PatternRulePair;
import com.sun.jersey.impl.uri.rules.RightHandPathRule;
import com.sun.jersey.impl.uri.rules.SequentialMatchingPatterns;
import com.sun.jersey.impl.uri.rules.SubLocatorRule;
import com.sun.jersey.impl.uri.rules.TerminatingRule;
import com.sun.jersey.impl.uri.rules.UriRulesFactory;
import com.sun.jersey.impl.wadl.WadlFactory;
import com.sun.jersey.spi.resource.InjectableProviderContext;
import com.sun.jersey.spi.resource.ResourceProvider;
import com.sun.jersey.spi.resource.ResourceProviderFactory;
import com.sun.jersey.spi.service.ComponentProvider;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceClass {
    private static final Logger LOGGER = Logger.getLogger(ResourceClass.class.getName());
    private final UriRules<UriRule> rules;
    private final ResourceConfig config;
    private final WadlFactory wadlFactory;
    public final AbstractResource resource;
    public ResourceProvider provider;

    public ResourceClass(ResourceConfig config, ComponentProvider provider, ResourceMethodDispatcherFactory df, InjectableProviderContext injectableContext, AbstractResource resource, WadlFactory wadlFactory) {
        this.resource = resource;
        this.config = config;
        this.wadlFactory = wadlFactory;
        RulesMap<UriRule> rulesMap = new RulesMap<UriRule>();
        this.processSubResourceLocators(injectableContext, rulesMap);
        Map<PathPattern, ResourceMethodMap> patternMethodMap = this.processSubResourceMethods(df);
        ResourceMethodMap methodMap = this.processMethods(df);
        for (Map.Entry<PathPattern, ResourceMethodMap> e : patternMethodMap.entrySet()) {
            PathPattern p = e.getKey();
            ResourceMethodMap rmm = e.getValue();
            rmm.sort();
            rulesMap.put(p, new RightHandPathRule(config.getFeature("com.sun.jersey.config.feature.Redirect"), p.getTemplate().endsWithSlash(), new HttpMethodRule(rmm, true)));
        }
        methodMap.sort();
        if (!methodMap.isEmpty()) {
            rulesMap.put(PathPattern.EMPTY_PATH, new HttpMethodRule(methodMap));
        }
        UriRules<UriRule> atomicRules = UriRulesFactory.create(rulesMap);
        ArrayList patterns = new ArrayList();
        if (config.getFeature("com.sun.jersey.config.feature.ImplicitViewables")) {
            ViewableRule r = new ViewableRule();
            provider.inject(r);
            patterns.add(new PatternRulePair<ViewableRule>(new UriPattern("/([^/]+)"), r));
            patterns.add(new PatternRulePair<ViewableRule>(new UriPattern(null), r));
        }
        patterns.add(new PatternRulePair<TerminatingRule>(new UriPattern(".*"), new TerminatingRule()));
        patterns.add(new PatternRulePair<TerminatingRule>(new UriPattern(null), new TerminatingRule()));
        SequentialMatchingPatterns sequentialRules = new SequentialMatchingPatterns(patterns);
        CombiningMatchingPatterns<UriRule> combiningRules = new CombiningMatchingPatterns<UriRule>(Arrays.asList(atomicRules, sequentialRules));
        this.rules = combiningRules;
    }

    public void init(ComponentProvider provider, ComponentProvider resourceProvider, ResourceProviderFactory providerFactory) {
        this.provider = providerFactory.createProvider(provider, resourceProvider, this.resource, this.config.getFeatures(), this.config.getProperties());
    }

    public UriRules<UriRule> getRules() {
        return this.rules;
    }

    private void addToPatternMethodMap(Map<PathPattern, ResourceMethodMap> tmm, PathPattern p, ResourceMethod rm) {
        ResourceMethodMap rmm = tmm.get(p);
        if (rmm == null) {
            rmm = new ResourceMethodMap();
            tmm.put(p, rmm);
        }
        rmm.put(rm);
    }

    private void processSubResourceLocators(InjectableProviderContext injectableContext, RulesMap<UriRule> rulesMap) {
        for (AbstractSubResourceLocator locator : this.resource.getSubResourceLocators()) {
            PathTemplate t = new PathTemplate(locator.getUriPath().getValue(), locator.getUriPath().isEncode(), locator.getUriPath().isLimited());
            PathPattern p = new PathPattern(t, locator.getUriPath().isLimited());
            SubLocatorRule r = new SubLocatorRule(t, locator.getMethod(), injectableContext.getInjectable(locator.getParameters(), ComponentProvider.Scope.PerRequest));
            rulesMap.put(p, new RightHandPathRule(this.config.getFeature("com.sun.jersey.config.feature.Redirect"), t.endsWithSlash(), r));
        }
    }

    private Map<PathPattern, ResourceMethodMap> processSubResourceMethods(ResourceMethodDispatcherFactory df) {
        HashMap<PathPattern, ResourceMethodMap> patternMethodMap = new HashMap<PathPattern, ResourceMethodMap>();
        for (AbstractSubResourceMethod abstractSubResourceMethod : this.resource.getSubResourceMethods()) {
            PathTemplate t = new PathTemplate(abstractSubResourceMethod.getUriPath().getValue(), abstractSubResourceMethod.getUriPath().isEncode(), abstractSubResourceMethod.getUriPath().isLimited());
            PathPattern p = new PathPattern(t, abstractSubResourceMethod.getUriPath().isLimited());
            ResourceHttpMethod rm = new ResourceHttpMethod(df, t, abstractSubResourceMethod);
            this.addToPatternMethodMap(patternMethodMap, p, rm);
        }
        for (Map.Entry entry : patternMethodMap.entrySet()) {
            this.processHead((ResourceMethodMap)entry.getValue());
            this.processOptions((ResourceMethodMap)entry.getValue(), this.resource, (PathPattern)entry.getKey());
        }
        return patternMethodMap;
    }

    private ResourceMethodMap processMethods(ResourceMethodDispatcherFactory df) {
        ResourceMethodMap methodMap = new ResourceMethodMap();
        for (AbstractResourceMethod resourceMethod : this.resource.getResourceMethods()) {
            ResourceHttpMethod rm = new ResourceHttpMethod(df, resourceMethod);
            methodMap.put(rm);
        }
        this.processHead(methodMap);
        this.processOptions(methodMap, this.resource, null);
        return methodMap;
    }

    private void processHead(ResourceMethodMap methodMap) {
        List getList = (List)methodMap.get("GET");
        if (getList == null || getList.isEmpty()) {
            return;
        }
        List<ResourceMethod> headList = (ArrayList<ResourceMethod>)methodMap.get("HEAD");
        if (headList == null) {
            headList = new ArrayList<ResourceMethod>();
        }
        for (ResourceMethod getMethod : getList) {
            if (this.containsMediaOfMethod(headList, getMethod)) continue;
            ResourceHeadWrapperMethod headMethod = new ResourceHeadWrapperMethod(getMethod);
            methodMap.put(headMethod);
            headList = (List)methodMap.get("HEAD");
        }
    }

    private boolean containsMediaOfMethod(List<ResourceMethod> methods, ResourceMethod method) {
        for (ResourceMethod m : methods) {
            if (!method.mediaEquals(m)) continue;
            return true;
        }
        return false;
    }

    private void processOptions(ResourceMethodMap methodMap, AbstractResource resource, PathPattern p) {
        List l = (List)methodMap.get("OPTIONS");
        if (l != null) {
            return;
        }
        ResourceMethod optionsMethod = this.wadlFactory.createWadlOptionsMethod(methodMap, resource, p);
        if (optionsMethod == null) {
            optionsMethod = new ResourceHttpOptionsMethod(methodMap);
        }
        methodMap.put(optionsMethod);
    }
}

