/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.client.urlconnection;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.spi.container.InBoundHeaders;
import com.sun.jersey.spi.container.MessageBodyWorkers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLConnectionClientHandler
implements ClientHandler {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    @Context
    private MessageBodyWorkers bodyContext;

    @Override
    public ClientResponse handle(ClientRequest ro) {
        try {
            return this._invoke(ro);
        }
        catch (Exception ex) {
            throw new ClientHandlerException(ex);
        }
    }

    private ClientResponse _invoke(ClientRequest ro) throws ProtocolException, IOException {
        Boolean followRedirects;
        Integer connectTimeout;
        HttpURLConnection uc = (HttpURLConnection)ro.getURI().toURL().openConnection();
        Integer readTimeout = (Integer)ro.getProperties().get("com.sun.jersey.client.property.readTimeout");
        if (readTimeout != null) {
            uc.setReadTimeout(readTimeout);
        }
        if ((connectTimeout = (Integer)ro.getProperties().get("com.sun.jersey.client.property.connectTimeout")) != null) {
            uc.setConnectTimeout(connectTimeout);
        }
        if ((followRedirects = (Boolean)ro.getProperties().get("com.sun.jersey.client.property.followRedirects")) != null) {
            uc.setInstanceFollowRedirects(followRedirects);
        }
        uc.setRequestMethod(ro.getMethod());
        this.writeHeaders(ro.getMetadata(), uc);
        Object entity = ro.getEntity();
        if (entity != null) {
            uc.setDoOutput(true);
            this.writeEntity(uc, ro, entity);
        }
        return new URLConnectionResponse(ro.getMethod(), uc.getResponseCode(), uc);
    }

    private void writeHeaders(MultivaluedMap<String, Object> metadata, HttpURLConnection uc) {
        for (Map.Entry e : metadata.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                uc.setRequestProperty((String)e.getKey(), this.getHeaderValue(vs.get(0)));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (Object v : (List)e.getValue()) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append(this.getHeaderValue(v));
            }
            uc.setRequestProperty((String)e.getKey(), b.toString());
        }
    }

    private String getHeaderValue(Object headerValue) {
        RuntimeDelegate.HeaderDelegate hp = RuntimeDelegate.getInstance().createHeaderDelegate(headerValue.getClass());
        return hp.toString(headerValue);
    }

    private void writeEntity(HttpURLConnection uc, ClientRequest ro, Object entity) throws IOException {
        MultivaluedMap<String, Object> metadata = ro.getMetadata();
        MediaType mediaType = null;
        Object mediaTypeHeader = metadata.getFirst((Object)"Content-Type");
        mediaType = mediaTypeHeader instanceof MediaType ? (MediaType)mediaTypeHeader : (mediaTypeHeader != null ? MediaType.valueOf((String)mediaTypeHeader.toString()) : new MediaType("application", "octet-stream"));
        MessageBodyWriter<?> bw = this.bodyContext.getMessageBodyWriter(entity.getClass(), null, null, mediaType);
        if (bw == null) {
            throw new ClientHandlerException("A message body writer for Java type, " + entity.getClass() + ", and MIME media type, " + mediaType + ", was not found");
        }
        long size = bw.getSize(entity);
        if (size != -1L && size < Integer.MAX_VALUE) {
            uc.setFixedLengthStreamingMode((int)size);
        } else {
            Integer chunkedEncodingSize = (Integer)ro.getProperties().get("com.sun.jersey.client.property.chunkedEncodingSize");
            if (chunkedEncodingSize != null) {
                uc.setChunkedStreamingMode(chunkedEncodingSize);
            }
        }
        OutputStream out = uc.getOutputStream();
        bw.writeTo(entity, entity.getClass(), entity.getClass(), EMPTY_ANNOTATIONS, mediaType, metadata, out);
        out.flush();
        out.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class URLConnectionResponse
    extends ClientResponse {
        private final String method;
        private final int status;
        private final HttpURLConnection uc;
        private final MultivaluedMap<String, String> metadata;
        private Map<String, Object> properties;

        URLConnectionResponse(String method, int status, HttpURLConnection uc) {
            this.method = method;
            this.status = status;
            this.uc = uc;
            this.metadata = new InBoundHeaders();
            for (Map.Entry<String, List<String>> e : uc.getHeaderFields().entrySet()) {
                if (e.getKey() == null) continue;
                this.metadata.put((Object)e.getKey(), e.getValue());
            }
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public MultivaluedMap<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public boolean hasEntity() {
            if (this.method.equals("HEAD")) {
                return false;
            }
            int l = this.uc.getContentLength();
            return l > 0 || l == -1;
        }

        @Override
        public <T> T getEntity(Class<T> c) {
            try {
                MediaType mediaType = this.getType();
                MessageBodyReader<T> br = URLConnectionClientHandler.this.bodyContext.getMessageBodyReader(c, c, EMPTY_ANNOTATIONS, mediaType);
                if (br == null) {
                    throw new ClientHandlerException("A message body reader for Java type, " + c + ", and MIME media type, " + mediaType + ", was not found");
                }
                InputStream in = this.getInputStream();
                Object t = br.readFrom(c, null, null, mediaType, this.metadata, this.getInputStream());
                if (!(t instanceof InputStream)) {
                    in.close();
                }
                return (T)t;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public Map<String, Object> getProperties() {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = new HashMap<String, Object>();
            return this.properties;
        }

        private InputStream getInputStream() throws IOException {
            if (this.status < 300) {
                return this.uc.getInputStream();
            }
            InputStream in = this.uc.getErrorStream();
            return in != null ? in : new ByteArrayInputStream(new byte[0]);
        }
    }
}

