/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.simple.impl.container;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.spi.container.ContainerListener;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.simpleframework.http.Address;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;
import org.simpleframework.http.core.Container;

public final class SimpleContainer
implements Container,
ContainerListener {
    private WebApplication application;

    public SimpleContainer(WebApplication application) throws ContainerException {
        this.application = application;
    }

    public void handle(Request request, Response response) {
        WebApplication target = this.application;
        URI baseUri = this.getBaseUri(request);
        URI requestUri = baseUri.resolve(request.getTarget());
        try {
            ContainerRequest cRequest = new ContainerRequest(target, request.getMethod(), baseUri, requestUri, this.getHeaders(request), request.getInputStream());
            target.handleRequest(cRequest, (ContainerResponseWriter)new Writer(request, response));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.close(response);
        }
    }

    private void close(Response response) {
        try {
            response.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private URI getBaseUri(Request request) {
        try {
            Address address = request.getAddress();
            return new URI(address.getScheme(), null, address.getDomain(), address.getPort(), "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private InBoundHeaders getHeaders(Request request) {
        InBoundHeaders header = new InBoundHeaders();
        List names = request.getNames();
        for (String name : names) {
            String value = request.getValue(name);
            header.add(name, (Object)value);
        }
        return header;
    }

    public void onReload() {
        WebApplication oldApplication = this.application;
        this.application = this.application.clone();
        oldApplication.destroy();
    }

    private static final class Writer
    implements ContainerResponseWriter {
        final Response response;
        final Request request;

        Writer(Request request, Response response) {
            this.response = response;
            this.request = request;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse cResponse) throws IOException {
            int code = cResponse.getStatus();
            String text = Status.getDescription((int)code);
            String method = this.request.getMethod();
            this.response.setCode(code);
            this.response.setText(text);
            if (!method.equalsIgnoreCase("HEAD") && contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            for (Map.Entry e : cResponse.getHttpHeaders().entrySet()) {
                for (Object value : (List)e.getValue()) {
                    this.response.add((String)e.getKey(), ContainerResponse.getHeaderValue(value));
                }
            }
            return this.response.getOutputStream();
        }

        public void finish() throws IOException {
            this.response.close();
        }
    }
}

