/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server.api;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.oauth.server.NonceManager;
import com.sun.jersey.oauth.server.OAuthException;
import com.sun.jersey.oauth.server.OAuthSecurityContext;
import com.sun.jersey.oauth.server.OAuthServerRequest;
import com.sun.jersey.oauth.server.spi.OAuthConsumer;
import com.sun.jersey.oauth.server.spi.OAuthProvider;
import com.sun.jersey.oauth.server.spi.OAuthToken;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignature;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class OAuthServerFilter
implements ContainerRequestFilter {
    public static final String PROPERTY_REALM = "com.sun.jersey.config.property.oauth.realm";
    public static final String PROPERTY_IGNORE_PATH_PATTERN = "com.sun.jersey.config.property.oauth.ignorePathPattern";
    public static final String PROPERTY_MAX_AGE = "com.sun.jersey.config.property.oauth.maxAge";
    public static final String PROPERTY_GC_PERIOD = "com.sun.jersey.config.property.oauth.gcPeriod";
    public static final String FEATURE_NO_FAIL = "com.sun.jersey.config.feature.oauth.noFail";
    private final OAuthProvider provider;
    private final NonceManager nonces;
    private final int maxAge;
    private final int gcPeriod;
    private final String wwwAuthenticateHeader;
    private final Set<String> versions;
    private final Pattern ignorePathPattern;
    private final boolean optional;

    public OAuthServerFilter(@Context ResourceConfig rc, @Context OAuthProvider provider) {
        this.provider = provider;
        HashSet<String> v = new HashSet<String>();
        v.add(null);
        v.add("1.0");
        this.versions = Collections.unmodifiableSet(v);
        String realm = OAuthServerFilter.defaultInitParam(rc, PROPERTY_REALM, "default");
        this.maxAge = OAuthServerFilter.intValue(OAuthServerFilter.defaultInitParam(rc, PROPERTY_MAX_AGE, "300000"));
        this.gcPeriod = OAuthServerFilter.intValue(OAuthServerFilter.defaultInitParam(rc, PROPERTY_GC_PERIOD, "100"));
        this.ignorePathPattern = OAuthServerFilter.pattern(OAuthServerFilter.defaultInitParam(rc, PROPERTY_IGNORE_PATH_PATTERN, null));
        this.optional = rc.getFeature(FEATURE_NO_FAIL);
        this.nonces = new NonceManager(this.maxAge, this.gcPeriod);
        this.wwwAuthenticateHeader = "OAuth realm=\"" + realm + "\"";
    }

    public ContainerRequest filter(ContainerRequest request) {
        String authHeader = request.getHeaderValue("Authorization");
        if (authHeader == null || !authHeader.toUpperCase().startsWith("OAuth".toUpperCase())) {
            return request;
        }
        if (OAuthServerFilter.match(this.ignorePathPattern, request.getPath())) {
            return request;
        }
        OAuthSecurityContext sc = null;
        try {
            sc = this.getSecurityContext(request);
        }
        catch (OAuthException e) {
            if (this.optional) {
                return request;
            }
            throw new WebApplicationException(e.toResponse());
        }
        request.setSecurityContext((SecurityContext)sc);
        return request;
    }

    private OAuthSecurityContext getSecurityContext(ContainerRequest request) throws OAuthException {
        OAuthSecurityContext sc;
        String nonceKey;
        OAuthServerRequest osr = new OAuthServerRequest((HttpRequestContext)request);
        OAuthParameters params = new OAuthParameters().readRequest((OAuthRequest)osr);
        if (params.size() == 0) {
            throw this.newUnauthorizedException();
        }
        String consumerKey = OAuthServerFilter.requiredOAuthParam(params.getConsumerKey());
        String token = params.getToken();
        String timestamp = OAuthServerFilter.requiredOAuthParam(params.getTimestamp());
        String nonce = OAuthServerFilter.requiredOAuthParam(params.getNonce());
        OAuthServerFilter.requiredOAuthParam(params.getSignature());
        OAuthServerFilter.supportedOAuthParam(params.getVersion(), this.versions);
        OAuthConsumer consumer = this.provider.getConsumer(consumerKey);
        if (consumer == null) {
            throw this.newUnauthorizedException();
        }
        OAuthSecrets secrets = new OAuthSecrets().consumerSecret(consumer.getSecret());
        if (token == null) {
            if (consumer.getPrincipal() == null) {
                throw this.newUnauthorizedException();
            }
            nonceKey = "c:" + consumerKey;
            sc = new OAuthSecurityContext(consumer, request.isSecure());
        } else {
            OAuthToken accessToken = this.provider.getAccessToken(token);
            if (accessToken == null) {
                throw this.newUnauthorizedException();
            }
            OAuthConsumer atConsumer = accessToken.getConsumer();
            if (atConsumer == null || !atConsumer.getSecret().equals(consumer.getSecret())) {
                throw this.newUnauthorizedException();
            }
            nonceKey = "t:" + token;
            secrets.tokenSecret(accessToken.getSecret());
            sc = new OAuthSecurityContext(accessToken, request.isSecure());
        }
        if (!OAuthServerFilter.verifySignature(osr, params, secrets)) {
            throw this.newUnauthorizedException();
        }
        if (!this.nonces.verify(nonceKey, timestamp, nonce)) {
            throw this.newUnauthorizedException();
        }
        return sc;
    }

    private static String defaultInitParam(ResourceConfig config, String name, String value) {
        String v = (String)config.getProperty(name);
        if (v == null || v.length() == 0) {
            v = value;
        }
        return v;
    }

    private static int intValue(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static String requiredOAuthParam(String value) throws OAuthException {
        if (value == null) {
            throw OAuthServerFilter.newBadRequestException();
        }
        return value;
    }

    private static String supportedOAuthParam(String value, Set<String> set) throws OAuthException {
        if (!set.contains(value)) {
            throw OAuthServerFilter.newBadRequestException();
        }
        return value;
    }

    private static Pattern pattern(String p) {
        if (p == null) {
            return null;
        }
        return Pattern.compile(p);
    }

    private static boolean match(Pattern pattern, String value) {
        return pattern != null && value != null && pattern.matcher(value).matches();
    }

    private static boolean verifySignature(OAuthServerRequest osr, OAuthParameters params, OAuthSecrets secrets) {
        try {
            return OAuthSignature.verify((OAuthRequest)osr, (OAuthParameters)params, (OAuthSecrets)secrets);
        }
        catch (OAuthSignatureException ose) {
            throw OAuthServerFilter.newBadRequestException();
        }
    }

    private static OAuthException newBadRequestException() throws OAuthException {
        return new OAuthException(Response.Status.BAD_REQUEST, null);
    }

    private OAuthException newUnauthorizedException() throws OAuthException {
        return new OAuthException(Response.Status.UNAUTHORIZED, this.wwwAuthenticateHeader);
    }
}

