/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.oauth.server.spi.OAuthProvider;
import com.sun.jersey.spi.inject.ConstrainedTo;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.ServerSide;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;

@ConstrainedTo(value=ServerSide.class)
public class OAuthProviderInjectionProvider
implements Injectable<OAuthProvider>,
InjectableProvider<Context, Type> {
    private static final Logger LOGGER = Logger.getLogger(OAuthProviderInjectionProvider.class.getName());
    private final OAuthProvider instance;

    public OAuthProviderInjectionProvider(@Context ProviderServices ps) {
        Iterator providers = ps.getProviders(OAuthProvider.class).iterator();
        if (!providers.hasNext()) {
            throw new RuntimeException("No OAuthProvider implementation found in the list of providers.");
        }
        this.instance = (OAuthProvider)providers.next();
        if (providers.hasNext()) {
            StringBuilder sb = new StringBuilder("More than one OAuthProvider implementations registered: ");
            sb.append(this.instance.getClass().getName());
            while (providers.hasNext()) {
                sb.append(", ").append(((OAuthProvider)providers.next()).getClass().getName());
            }
            LOGGER.warning(sb.toString());
        }
    }

    public OAuthProvider getValue() {
        return this.instance;
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    public Injectable getInjectable(ComponentContext cc, Context a, Type t) {
        Class c;
        if (t instanceof Class && OAuthProvider.class.isAssignableFrom(c = (Class)t) && c.isInstance(this.instance)) {
            return this;
        }
        return null;
    }
}

