/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server.api.resources;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.oauth.server.OAuthException;
import com.sun.jersey.oauth.server.OAuthServerRequest;
import com.sun.jersey.oauth.server.spi.OAuthConsumer;
import com.sun.jersey.oauth.server.spi.OAuthProvider;
import com.sun.jersey.oauth.server.spi.OAuthToken;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignature;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/requestToken")
public class RequestTokenRequest {
    @Context
    private OAuthProvider provider;
    @Context
    private HttpContext hc;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response postReqTokenRequest() {
        try {
            OAuthServerRequest request = new OAuthServerRequest(this.hc.getRequest());
            OAuthParameters params = new OAuthParameters();
            params.readRequest((OAuthRequest)request);
            String tok = params.getToken();
            if (tok != null && !tok.contentEquals("")) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            String consKey = params.getConsumerKey();
            if (consKey == null) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            OAuthConsumer consumer = this.provider.getConsumer(consKey);
            if (consumer == null) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            OAuthSecrets secrets = new OAuthSecrets().consumerSecret(consumer.getSecret()).tokenSecret("");
            boolean sigIsOk = false;
            try {
                sigIsOk = OAuthSignature.verify((OAuthRequest)request, (OAuthParameters)params, (OAuthSecrets)secrets);
            }
            catch (OAuthSignatureException ex) {
                Logger.getLogger(RequestTokenRequest.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!sigIsOk) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            MultivaluedMapImpl parameters = new MultivaluedMapImpl();
            for (String n : request.getParameterNames()) {
                parameters.put((Object)n, request.getParameterValues(n));
            }
            OAuthToken rt = this.provider.newRequestToken(consKey, params.getCallback(), (Map<String, List<String>>)parameters);
            Form resp = new Form();
            resp.putSingle("oauth_token", rt.getToken());
            resp.putSingle("oauth_token_secret", rt.getSecret());
            resp.putSingle("oauth_callback_confirmed", "true");
            return Response.ok((Object)resp).build();
        }
        catch (OAuthException e) {
            return e.toResponse();
        }
    }
}

