/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server.api.resources;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.oauth.server.OAuthException;
import com.sun.jersey.oauth.server.OAuthServerRequest;
import com.sun.jersey.oauth.server.spi.OAuthConsumer;
import com.sun.jersey.oauth.server.spi.OAuthProvider;
import com.sun.jersey.oauth.server.spi.OAuthToken;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignature;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Path(value="/accessToken")
public class AccessTokenRequest {
    @Context
    private OAuthProvider provider;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response postAccessTokenRequest(@Context HttpContext hc, @Context Request req) {
        try {
            boolean sigIsOk = false;
            OAuthServerRequest request = new OAuthServerRequest(hc.getRequest());
            OAuthParameters params = new OAuthParameters();
            params.readRequest((OAuthRequest)request);
            if (params.getToken() == null) {
                throw new WebApplicationException(new Throwable("oauth_token MUST be present."), 400);
            }
            String consKey = params.getConsumerKey();
            if (consKey == null) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            OAuthToken rt = this.provider.getRequestToken(params.getToken());
            if (rt == null) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            OAuthConsumer consumer = rt.getConsumer();
            if (consumer == null || !consKey.equals(consumer.getKey())) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            OAuthSecrets secrets = new OAuthSecrets().consumerSecret(consumer.getSecret()).tokenSecret(rt.getSecret());
            try {
                sigIsOk = OAuthSignature.verify((OAuthRequest)request, (OAuthParameters)params, (OAuthSecrets)secrets);
            }
            catch (OAuthSignatureException ex) {
                Logger.getLogger(AccessTokenRequest.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!sigIsOk) {
                throw new OAuthException(Response.Status.BAD_REQUEST, null);
            }
            OAuthToken at = this.provider.newAccessToken(rt, params.getVerifier());
            Form resp = new Form();
            resp.putSingle("oauth_token", at.getToken());
            resp.putSingle("oauth_token_secret", at.getSecret());
            resp.putAll(at.getAttributes());
            return Response.ok((Object)resp).build();
        }
        catch (OAuthException e) {
            return e.toResponse();
        }
    }
}

