/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.util.LazyVal;
import com.sun.jersey.oauth.server.spi.OAuthProvider;
import com.sun.jersey.spi.inject.ConstrainedTo;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.ServerSide;
import java.lang.reflect.Type;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
@ConstrainedTo(value=ServerSide.class)
public class OAuthProviderInjectionProvider
implements Injectable<OAuthProvider>,
InjectableProvider<Context, Type> {
    @Context
    private ResourceConfig rc;
    private final LazyVal<OAuthProvider> instance = new LazyVal<OAuthProvider>(){

        protected OAuthProvider instance() {
            Class<?> providerClass;
            String providerClassName = (String)OAuthProviderInjectionProvider.this.rc.getProperty("com.sun.jersey.config.property.oauth.provider");
            if (providerClassName == null) {
                throw new RuntimeException("Missing OAuthProvider class name in the configuration. Make sure 'com.sun.jersey.config.property.oauth.provider' property is set.");
            }
            try {
                providerClass = Class.forName(providerClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not load OAuthProvider implementation: " + ex.getMessage(), ex);
            }
            OAuthProvider provider = null;
            for (Object obj : OAuthProviderInjectionProvider.this.rc.getProviderSingletons()) {
                if (obj.getClass() != providerClass) continue;
                provider = (OAuthProvider)obj;
                break;
            }
            if (provider == null) {
                try {
                    provider = (OAuthProvider)providerClass.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException("Could not instantiate OAuthProvider class", ex);
                }
            }
            return provider;
        }
    };

    public OAuthProvider getValue() {
        return (OAuthProvider)this.instance.get();
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    public Injectable getInjectable(ComponentContext cc, Context a, Type t) {
        Class c;
        if (t instanceof Class && OAuthProvider.class.isAssignableFrom(c = (Class)t) && c.isInstance(this.instance.get())) {
            return this;
        }
        return null;
    }
}

