/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server.providers;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.oauth.server.spi.OAuthProvider;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
public class OAuthProviderInjectionProvider
implements Injectable<OAuthProvider>,
InjectableProvider<Context, Type> {
    private final OAuthProvider instance;

    public OAuthProviderInjectionProvider(@Context ResourceConfig rc) {
        OAuthProvider provider = null;
        for (Object obj : rc.getProviderSingletons()) {
            if (!(obj instanceof OAuthProvider)) continue;
            if (provider == null) {
                provider = (OAuthProvider)obj;
                continue;
            }
            Logger.getLogger(OAuthProviderInjectionProvider.class.getName()).log(Level.WARNING, "Multiple instances of OAuthProvider registered. Using: " + provider.getClass().getName());
            break;
        }
        if (provider == null) {
            for (Class cls : rc.getProviderClasses()) {
                if (!OAuthProvider.class.isAssignableFrom(cls)) continue;
                try {
                    if (provider == null) {
                        provider = (OAuthProvider)cls.newInstance();
                        continue;
                    }
                    Logger.getLogger(OAuthProviderInjectionProvider.class.getName()).log(Level.WARNING, "Multiple implementations of OAuthProvider registered. Using: " + provider.getClass().getName());
                    break;
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(OAuthProviderInjectionProvider.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(OAuthProviderInjectionProvider.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (provider == null) {
            throw new RuntimeException("No implementation of OAuthProvider class registered");
        }
        this.instance = provider;
    }

    public OAuthProvider getValue() {
        return this.instance;
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    public Injectable getInjectable(ComponentContext cc, Context a, Type c) {
        if (OAuthProvider.class == c) {
            return this;
        }
        return null;
    }
}

