/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server;

import com.sun.jersey.oauth.server.spi.OAuthConsumer;
import com.sun.jersey.oauth.server.spi.OAuthToken;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class OAuthSecurityContext
implements SecurityContext {
    private final OAuthConsumer consumer;
    private final OAuthToken token;
    private final boolean isSecure;

    public OAuthSecurityContext(OAuthConsumer consumer, boolean isSecure) {
        this.consumer = consumer;
        this.token = null;
        this.isSecure = isSecure;
    }

    public OAuthSecurityContext(OAuthToken token, boolean isSecure) {
        this.consumer = null;
        this.token = token;
        this.isSecure = isSecure;
    }

    public Principal getUserPrincipal() {
        return this.consumer == null ? this.token.getPrincipal() : this.consumer.getPrincipal();
    }

    public boolean isUserInRole(String string) {
        return this.consumer == null ? this.token.isInRole(string) : this.consumer.isInRole(string);
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getAuthenticationScheme() {
        return "OAuth";
    }
}

