/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.oauth.signature.OAuthRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthServerRequest
implements OAuthRequest {
    private HttpRequestContext context;
    private static HashSet<String> EMPTY_SET = new HashSet();
    private static ArrayList<String> EMPTY_LIST = new ArrayList();

    public OAuthServerRequest(HttpRequestContext context) {
        this.context = context;
    }

    public String getRequestMethod() {
        return this.context.getMethod();
    }

    public String getRequestURL() {
        return this.context.getAbsolutePath().toString();
    }

    private static Set<String> keys(MultivaluedMap<String, String> mvm) {
        if (mvm == null) {
            return EMPTY_SET;
        }
        Set s = mvm.keySet();
        if (s == null) {
            return EMPTY_SET;
        }
        return s;
    }

    private static List<String> values(MultivaluedMap<String, String> mvm, String key) {
        if (mvm == null) {
            return EMPTY_LIST;
        }
        List v = (List)mvm.get((Object)key);
        if (v == null) {
            return EMPTY_LIST;
        }
        return v;
    }

    public Set<String> getParameterNames() {
        HashSet<String> n = new HashSet<String>();
        n.addAll(OAuthServerRequest.keys((MultivaluedMap<String, String>)this.context.getQueryParameters()));
        n.addAll(OAuthServerRequest.keys((MultivaluedMap<String, String>)this.context.getFormParameters()));
        return n;
    }

    public List<String> getParameterValues(String name) {
        ArrayList<String> v = new ArrayList<String>();
        v.addAll(OAuthServerRequest.values((MultivaluedMap<String, String>)this.context.getQueryParameters(), name));
        v.addAll(OAuthServerRequest.values((MultivaluedMap<String, String>)this.context.getFormParameters(), name));
        return v;
    }

    public List<String> getHeaderValues(String name) {
        return this.context.getRequestHeader(name);
    }

    public void addHeaderValue(String name, String value) throws IllegalStateException {
        throw new IllegalStateException("Modifying OAuthServerRequest unsupported");
    }
}

