/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.non.blocking;

import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.sun.jersey.api.client.AsyncViewResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.async.FutureListener;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.non.blocking.NonBlockingClient;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class NonBlockingAsyncViewResource
extends AsyncViewResource {
    private final NonBlockingClient client;

    protected NonBlockingAsyncViewResource(NonBlockingClient c, URI u) {
        super((Client)c, u);
        this.client = c;
    }

    protected NonBlockingAsyncViewResource(NonBlockingAsyncViewResource that, UriBuilder ub) {
        super((AsyncViewResource)that, ub);
        this.client = that.client;
    }

    public void addFilter(ClientFilter f) {
        throw new UnsupportedOperationException();
    }

    public void removeFilter(ClientFilter f) {
        throw new UnsupportedOperationException();
    }

    public boolean isFilterPreset(ClientFilter f) {
        throw new UnsupportedOperationException();
    }

    public void removeAllFilters() {
        throw new UnsupportedOperationException();
    }

    public ClientHandler getHeadHandler() {
        throw new UnsupportedOperationException();
    }

    public AsyncViewResource queryParams(MultivaluedMap<String, String> params) {
        UriBuilder b = this.getUriBuilder();
        for (Map.Entry e : params.entrySet()) {
            for (String value : (List)e.getValue()) {
                b.queryParam((String)e.getKey(), new Object[]{value});
            }
        }
        return new NonBlockingAsyncViewResource(this, b);
    }

    public AsyncViewResource queryParam(String key, String value) {
        UriBuilder b = this.getUriBuilder();
        b.queryParam(key, new Object[]{value});
        return new NonBlockingAsyncViewResource(this, b);
    }

    public AsyncViewResource uri(URI uri) {
        String query;
        UriBuilder b = this.getUriBuilder();
        String path = uri.getRawPath();
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                b.replacePath(path);
            } else {
                b.path(path);
            }
        }
        if ((query = uri.getRawQuery()) != null && query.length() > 0) {
            b.replaceQuery(query);
        }
        return new NonBlockingAsyncViewResource(this, b);
    }

    public AsyncViewResource path(String path) {
        return new NonBlockingAsyncViewResource(this, this.getUriBuilder().path(path));
    }

    public Future<ClientResponse> handle(ClientRequest request, final FutureListener<ClientResponse> l) {
        Request r = this.client.getRequest(request);
        try {
            final ListenableFuture listenableFuture = this.client.getClientHandlerNing().getHttpClient().executeRequest(r);
            final Future<ClientResponse> jerseyFuture = new Future<ClientResponse>(){

                @Override
                public boolean cancel(boolean b) {
                    return listenableFuture.cancel(b);
                }

                @Override
                public boolean isCancelled() {
                    return listenableFuture.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return listenableFuture.isDone();
                }

                @Override
                public ClientResponse get() throws InterruptedException, ExecutionException {
                    Response response = (Response)listenableFuture.get();
                    if (response != null) {
                        return NonBlockingAsyncViewResource.this.client.getClientResponse(response);
                    }
                    return null;
                }

                @Override
                public ClientResponse get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                    Response response = (Response)listenableFuture.get(l, timeUnit);
                    if (response != null) {
                        return NonBlockingAsyncViewResource.this.client.getClientResponse(response);
                    }
                    return null;
                }
            };
            listenableFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        l.onComplete(jerseyFuture);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }, new Executor(){

                @Override
                public void execute(Runnable runnable) {
                    runnable.run();
                }
            });
            return jerseyFuture;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

