/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.non.blocking;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.RequestWriter;
import com.sun.jersey.api.client.TerminatingClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.util.ReaderWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.core.MultivaluedMap;

public final class NonBlockingClientHandler
extends TerminatingClientHandler {
    private final AsyncHttpClient client;
    private final ExecutorService executorService;
    private final ClientConfig clientConfig;
    private final ThreadLocal<Collection<Cookie>> cookieStore = new ThreadLocal<Collection<Cookie>>(){

        @Override
        protected Collection<Cookie> initialValue() {
            return new HashSet<Cookie>();
        }
    };

    public NonBlockingClientHandler(ClientConfig cc) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (cc != null) {
            Object responseFilters;
            Object requestFilters;
            Object executorService = cc.getProperty("com.sun.jersey.impl.client.non.blocking.executorService");
            if (executorService != null && executorService instanceof ExecutorService) {
                builder = builder.setExecutorService((ExecutorService)executorService);
                this.executorService = (ExecutorService)executorService;
            } else {
                Object threadpoolSize = cc.getProperties().get("com.sun.jersey.client.property.threadpoolSize");
                this.executorService = threadpoolSize != null && threadpoolSize instanceof Integer && (Integer)threadpoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadpoolSize) : Executors.newCachedThreadPool();
                builder = builder.setExecutorService(this.executorService);
            }
            Integer timeout = (Integer)cc.getProperties().get("com.sun.jersey.client.property.connectTimeout");
            if (timeout != null) {
                builder = builder.setConnectionTimeoutInMs(timeout.intValue());
            }
            Object username = cc.getProperties().get("com.sun.jersey.impl.client.non.blocking.auth.userName");
            Object password = cc.getProperties().get("com.sun.jersey.impl.client.non.blocking.auth.password");
            if (username != null && password != null) {
                boolean preemptiveAuth = cc.getPropertyAsFeature("com.sun.jersey.impl.client.non.blocking.auth.preemptive");
                Object scheme = cc.getProperties().get("com.sun.jersey.impl.client.non.blocking.auth.scheme");
                Realm.AuthScheme authScheme = Realm.AuthScheme.NONE;
                if (scheme != null) {
                    if (scheme.equals("DIGEST")) {
                        authScheme = Realm.AuthScheme.DIGEST;
                    } else if (scheme.equals("KERBEROS")) {
                        authScheme = Realm.AuthScheme.KERBEROS;
                    } else if (scheme.equals("NTLM")) {
                        authScheme = Realm.AuthScheme.NTLM;
                    } else if (scheme.equals("SPNEGO")) {
                        authScheme = Realm.AuthScheme.SPNEGO;
                    }
                } else {
                    authScheme = Realm.AuthScheme.BASIC;
                }
                Realm realm = new Realm.RealmBuilder().setPrincipal(username.toString()).setPassword(password.toString()).setUsePreemptiveAuth(preemptiveAuth).setScheme(authScheme).build();
                builder = builder.setRealm(realm);
            }
            if ((requestFilters = cc.getProperties().get("com.sun.jersey.impl.client.non.blocking.requestFilter")) != null) {
                if (requestFilters instanceof RequestFilter) {
                    builder.addRequestFilter((RequestFilter)requestFilters);
                } else if (requestFilters instanceof List) {
                    List requestFilterList = (List)requestFilters;
                    ListIterator iterator = requestFilterList.listIterator(requestFilterList.size());
                    while (iterator.hasPrevious()) {
                        Object listElement = iterator.previous();
                        if (!(listElement instanceof RequestFilter)) continue;
                        builder.addRequestFilter((RequestFilter)listElement);
                    }
                }
            }
            if ((responseFilters = cc.getProperties().get("com.sun.jersey.impl.client.non.blocking.responseFilter")) != null) {
                if (responseFilters instanceof ResponseFilter) {
                    builder.addResponseFilter((ResponseFilter)responseFilters);
                } else if (responseFilters instanceof List) {
                    List responseFiltersList = (List)responseFilters;
                    ListIterator iterator = responseFiltersList.listIterator(responseFiltersList.size());
                    while (iterator.hasPrevious()) {
                        Object listElement = iterator.previous();
                        if (!(listElement instanceof ResponseFilter)) continue;
                        builder.addResponseFilter((ResponseFilter)listElement);
                    }
                }
            }
        } else {
            this.executorService = Executors.newCachedThreadPool();
            builder.setExecutorService(this.executorService);
        }
        AsyncHttpClientConfig config = builder.build();
        this.client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
        this.clientConfig = cc;
    }

    public AsyncHttpClient getHttpClient() {
        return this.client;
    }

    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        Request request = this.getRequest(cr);
        try {
            ListenableFuture response = this.getHttpClient().executeRequest(request);
            return this.getClientResponse((Response)response.get());
        }
        catch (Exception e) {
            throw new ClientHandlerException((Throwable)e);
        }
    }

    ClientResponse getClientResponse(Response response) {
        if (this.clientConfig != null && !this.clientConfig.getPropertyAsFeature("com.sun.jersey.impl.client.non.blocking.handleCookies")) {
            this.cookieStore.get().addAll(response.getCookies());
        }
        try {
            ClientResponse r = new ClientResponse(response.getStatusCode(), this.getInBoundHeaders(response), (InputStream)new HttpClientResponseInputStream(response), this.getMessageBodyWorkers());
            if (!r.hasEntity()) {
                r.bufferEntity();
                r.close();
            }
            return r;
        }
        catch (Exception e) {
            throw new ClientHandlerException((Throwable)e);
        }
    }

    Request getRequest(ClientRequest cr) {
        ProxyServer proxyServer;
        String strMethod = cr.getMethod();
        URI uri = cr.getURI();
        RequestBuilder builder = new RequestBuilder(strMethod).setUrl(uri.toString());
        Request.EntityWriter entity = this.getHttpEntity(cr);
        if (entity != null) {
            builder = builder.setBody(entity);
        }
        if ((proxyServer = this.createProxyServer(cr)) != null) {
            builder.setProxyServer(proxyServer);
        }
        if (this.clientConfig != null) {
            if (!this.clientConfig.getPropertyAsFeature("com.sun.jersey.impl.client.non.blocking.handleCookies")) {
                for (Cookie cookie : this.cookieStore.get()) {
                    builder = builder.addCookie(cookie);
                }
                this.cookieStore.remove();
            }
            builder = this.clientConfig.getPropertyAsFeature("com.sun.jersey.client.property.followRedirects") ? builder.setFollowRedirects(true) : builder.setFollowRedirects(false);
        }
        Request request = builder.build();
        NonBlockingClientHandler.writeOutBoundHeaders((MultivaluedMap<String, Object>)cr.getHeaders(), request);
        return request;
    }

    private ProxyServer createProxyServer(ClientRequest cr) {
        Object proxyHost = cr.getProperties().get("com.sun.jersey.impl.client.non.blocking.proxy.host");
        if (proxyHost != null) {
            String proxyProto;
            String proxyPass;
            String proxyUser;
            ProxyServerBuilder proxyBuilder = new ProxyServerBuilder((String)proxyHost);
            Integer proxyPort = (Integer)cr.getProperties().get("com.sun.jersey.impl.client.non.blocking.proxy.port");
            if (proxyPort != null) {
                proxyBuilder.setPort(proxyPort);
            }
            if ((proxyUser = (String)cr.getProperties().get("com.sun.jersey.impl.client.non.blocking.proxy.username")) != null && (proxyPass = (String)cr.getProperties().get("com.sun.jersey.impl.client.non.blocking.proxy.password")) != null) {
                proxyBuilder.setUsername(proxyUser);
                proxyBuilder.setPassword(proxyPass);
            }
            if ((proxyProto = (String)cr.getProperties().get("com.sun.jersey.impl.client.non.blocking.proxy.protocol")) != null) {
                if (proxyProto.equals("HTTP")) {
                    proxyBuilder.setProtocol(ProxyServer.Protocol.HTTP);
                } else if (proxyProto.equals("HTTPS")) {
                    proxyBuilder.setProtocol(ProxyServer.Protocol.HTTPS);
                } else if (proxyProto.equals("NTLM")) {
                    proxyBuilder.setProtocol(ProxyServer.Protocol.NTLM);
                } else if (proxyProto.equals("SPNEGO")) {
                    proxyBuilder.setProtocol(ProxyServer.Protocol.SPNEGO);
                } else if (proxyProto.equals("KERBEROS")) {
                    proxyBuilder.setProtocol(ProxyServer.Protocol.KERBEROS);
                }
            }
            return proxyBuilder.build();
        }
        return null;
    }

    private Request.EntityWriter getHttpEntity(ClientRequest cr) {
        Object entity = cr.getEntity();
        if (entity == null) {
            return null;
        }
        final RequestWriter.RequestEntityWriter requestEntityWriter = this.getRequestEntityWriter(cr);
        return new Request.EntityWriter(){

            public void writeEntity(OutputStream out) throws IOException {
                requestEntityWriter.writeRequestEntity(out);
            }
        };
    }

    protected static void writeOutBoundHeaders(MultivaluedMap<String, Object> headers, Request request) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                request.getHeaders().add((String)e.getKey(), new String[]{ClientRequest.getHeaderValue(vs.get(0))});
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(ClientRequest.getHeaderValue(v));
            }
            request.getHeaders().add((String)e.getKey(), new String[]{b.toString()});
        }
    }

    private InBoundHeaders getInBoundHeaders(Response response) throws ExecutionException, InterruptedException {
        InBoundHeaders headers = new InBoundHeaders();
        FluentCaseInsensitiveStringsMap responseHeaders = response.getHeaders();
        for (Map.Entry header : responseHeaders) {
            headers.put(header.getKey(), header.getValue());
        }
        return headers;
    }

    private static InputStream getInputStream(Response response) throws IOException, ExecutionException, InterruptedException {
        if (!response.hasResponseBody()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        InputStream i = response.getResponseBodyAsStream();
        if (i.markSupported()) {
            return i;
        }
        return new BufferedInputStream(i, ReaderWriter.BUFFER_SIZE);
    }

    private static class ProxyServerBuilder {
        private String host = null;
        private Integer port = null;
        private String username = null;
        private String password = null;
        private ProxyServer.Protocol protocol = null;

        public ProxyServerBuilder(String host) {
            this.host = host;
        }

        public ProxyServerBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        public ProxyServerBuilder setUsername(String username) {
            this.username = username;
            return this;
        }

        public ProxyServerBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public ProxyServerBuilder setProtocol(ProxyServer.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public ProxyServer build() {
            return new ProxyServer(this.protocol, this.host, this.port.intValue(), this.username, this.password);
        }
    }

    static final class HttpClientResponseInputStream
    extends FilterInputStream {
        HttpClientResponseInputStream(Response response) throws IOException, ExecutionException, InterruptedException {
            super(NonBlockingClientHandler.getInputStream(response));
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

