/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.soimp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Proc {
    private final Process proc;
    private final Thread t1;
    private final Thread t2;

    public Proc(String cmd, String[] env, OutputStream out, File workDir) throws IOException {
        this(Runtime.getRuntime().exec(cmd, env, workDir), null, out);
    }

    public Proc(String[] cmd, String[] env, OutputStream out, File workDir) throws IOException {
        this(Runtime.getRuntime().exec(cmd, env, workDir), null, out);
    }

    public Proc(String[] cmd, String[] env, InputStream in, OutputStream out) throws IOException {
        this(Runtime.getRuntime().exec(cmd, env), in, out);
    }

    private Proc(Process proc, InputStream in, OutputStream out) throws IOException {
        this.proc = proc;
        this.t1 = new Copier(proc.getInputStream(), out);
        this.t1.start();
        this.t2 = new Copier(proc.getErrorStream(), out);
        this.t2.start();
        if (in != null) {
            new ByteCopier(in, proc.getOutputStream()).start();
        } else {
            proc.getOutputStream().close();
        }
    }

    public int join() {
        try {
            this.t1.join();
            this.t2.join();
            return this.proc.waitFor();
        }
        catch (InterruptedException e) {
            this.proc.destroy();
            return -1;
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[256];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    private static class ByteCopier
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public ByteCopier(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int ch;
                while ((ch = this.in.read()) != -1) {
                    this.out.write(ch);
                }
                this.in.close();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class Copier
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public Copier(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                Proc.copyStream(this.in, this.out);
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

