/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.maven;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class RSFileSet {
    private Path root;
    private List<String> inc = new ArrayList<String>();
    private final PathMatcher exMatcher = FileSystems.getDefault().getPathMatcher("glob:*_*.properties");

    public void setDirectory(String dir) {
        this.root = Paths.get(dir, new String[0]);
    }

    public String getDirectory() {
        return this.root.toString();
    }

    public boolean exists() {
        return Files.isDirectory(this.root, LinkOption.NOFOLLOW_LINKS);
    }

    public void addInclude(String include) {
        this.inc.add(include);
    }

    public List<String> getIncludes() {
        return this.inc;
    }

    public void setIncludes(List<String> inc) {
        this.inc = inc;
    }

    public Path resolve(Path path) {
        return this.root.resolve(path);
    }

    public List<Path> getIncludedFiles() {
        final ArrayList<Path> result = new ArrayList<Path>();
        if (this.inc.isEmpty()) {
            this.inc.add("**");
        }
        FileSystem fs = FileSystems.getDefault();
        for (String i : this.inc) {
            PathMatcher dirMatcher;
            PathMatcher matcher;
            int idx = i.indexOf(47);
            if (idx < 0) {
                matcher = fs.getPathMatcher("glob:" + i);
                dirMatcher = null;
            } else {
                matcher = fs.getPathMatcher("glob:" + i.substring(idx + 1));
                dirMatcher = fs.getPathMatcher("glob:" + i.substring(0, idx));
            }
            try {
                Files.walkFileTree(this.root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Path name;
                        if ((dirMatcher == null || dirMatcher.matches(file.getParent())) && (name = file.getFileName()) != null && matcher.matches(name) && !RSFileSet.this.exMatcher.matches(name)) {
                            result.add(RSFileSet.this.root.relativize(file));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }
}

