/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.maven;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.istack.maven.LicenseCodeWriter;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="quick-gen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class QuickGenMojo
extends AbstractMojo {
    private static final String LOCATABLE = "org.glassfish.jaxb.core.v2.model.annotation.Locatable";
    private static final String QUICK = "org.glassfish.jaxb.runtime.v2.model.annotation.Quick";
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/quick-sources")
    private File destDir;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(required=true)
    private List<String> classes;
    @Parameter
    private File license;
    @Parameter(required=true)
    private String packageName;
    @Parameter(defaultValue="true")
    private boolean attach;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private ClassLoader userLoader;
    private JCodeModel codeModel = new JCodeModel();
    private final JClass locatable = this.codeModel.ref("org.glassfish.jaxb.core.v2.model.annotation.Locatable");
    private final JClass quick = this.codeModel.ref("org.glassfish.jaxb.runtime.v2.model.annotation.Quick");
    private JPackage pkg = this.codeModel.rootPackage();
    private final Map<Class<? extends Annotation>, JDefinedClass> queue = new TreeMap<Class, JDefinedClass>(Comparator.comparing(Class::getName));

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        for (String s : this.classes) {
            this.patterns.add(Pattern.compile(this.convertToRegex(s)));
        }
        this.pkg = this.codeModel._package(this.packageName);
        try {
            List classpath = this.project.getCompileClasspathElements();
            HashSet<File> files = new HashSet<File>();
            ArrayList<URL> cp = new ArrayList<URL>();
            for (String s : classpath) {
                File f = new File(s);
                files.add(f);
                cp.add(f.toURI().toURL());
            }
            this.userLoader = new URLClassLoader(cp.toArray(new URL[0]));
            for (File f : files) {
                if (!f.exists()) continue;
                if (f.isDirectory()) {
                    this.processDir(f, "");
                    continue;
                }
                this.processJar(f);
            }
            try {
                JArray all = JExpr.newArray((JType)this.quick);
                JDefinedClass init = this.pkg._class(0, "Init");
                init.method(16, (JType)this.quick.array(), "getAll").body()._return((JExpression)all);
                for (Map.Entry<Class<? extends Annotation>, JDefinedClass> e : this.queue.entrySet()) {
                    this.process(e.getKey(), e.getValue());
                    all.add((JExpression)JExpr._new((JClass)((JClass)e.getValue())).arg(JExpr._null()).arg(JExpr._null()));
                }
            }
            catch (JClassAlreadyExistsException e) {
                throw new MojoExecutionException((Throwable)e);
            }
            if (!this.destDir.mkdirs()) {
                this.getLog().warn((CharSequence)(this.destDir + " failed to be created."));
            }
            Object core = new FileCodeWriter(this.destDir, this.encoding);
            if (this.license != null) {
                core = new LicenseCodeWriter((CodeWriter)core, this.license, this.encoding);
            }
            this.codeModel.build((CodeWriter)core);
            if (this.attach) {
                this.project.addCompileSourceRoot(this.destDir.getAbsolutePath());
            }
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e);
        }
        finally {
            this.userLoader = null;
        }
    }

    private void process(Class<? extends Annotation> ann, JDefinedClass c) {
        c.javadoc().add((Object)"<p><b>Auto-generated, do not edit.</b></p>");
        c._extends(this.quick);
        c._implements(ann);
        JFieldVar $core = c.field(12, ann, "core");
        JMethod m = c.constructor(1);
        m.body().invoke("super").arg((JExpression)m.param((JType)this.locatable, "upstream"));
        m.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)$core), (JExpression)m.param(ann, "core"));
        m = c.method(2, Annotation.class, "getAnnotation");
        m.annotate(Override.class);
        m.body()._return((JExpression)$core);
        m = c.method(2, (JType)this.quick, "newInstance");
        m.annotate(Override.class);
        m.body()._return((JExpression)JExpr._new((JClass)c).arg((JExpression)m.param((JType)this.locatable, "upstream")).arg((JExpression)JExpr.cast((JType)this.codeModel.ref(ann), (JExpression)m.param(Annotation.class, "core"))));
        m = c.method(1, (JType)this.codeModel.ref(Class.class).narrow(ann), "annotationType");
        m.annotate(Override.class);
        m.body()._return(this.codeModel.ref(ann).dotclass());
        Method[] methods = ann.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        for (Method method : methods) {
            JMethod m2 = c.method(1, method.getReturnType(), method.getName());
            m2.annotate(Override.class);
            m2.body()._return((JExpression)$core.invoke(method.getName()));
        }
    }

    private static String getShortName(String className) {
        int idx = className.lastIndexOf(46);
        return className.substring(idx + 1);
    }

    private String convertToRegex(String pattern) {
        StringBuilder regex = new StringBuilder();
        int nc = 32;
        if (pattern.length() > 0) {
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                nc = 32;
                if (i + 1 != pattern.length()) {
                    nc = pattern.charAt(i + 1);
                }
                if (c == '.' && nc != 46) {
                    regex.append('\\');
                    regex.append('.');
                    continue;
                }
                if (c == '.' && nc == 46) continue;
                if (c == '*' && nc == 42) {
                    regex.append(".*");
                    break;
                }
                if (c == '*') {
                    regex.append("[^\\.]+");
                    continue;
                }
                if (c == '?') {
                    regex.append("[^\\.]");
                    continue;
                }
                regex.append(c);
            }
        }
        return regex.toString();
    }

    private void processJar(File jarfile) throws MojoExecutionException {
        try (JarFile jar = new JarFile(jarfile);){
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry e = en.nextElement();
                this.process(e.getName(), e.getTime());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to process " + jarfile, (Exception)e);
        }
    }

    private void processDir(File dir, String prefix) throws MojoExecutionException {
        File[] subdirs;
        String[] classes = dir.list((d, name) -> name.endsWith(".class"));
        if (classes != null) {
            for (String c : classes) {
                this.process(prefix + c, new File(dir, c).lastModified());
            }
        }
        if ((subdirs = dir.listFiles(File::isDirectory)) != null) {
            for (File f : subdirs) {
                this.processDir(f, prefix + f.getName() + "/");
            }
        }
    }

    private void process(String name, long timestamp) throws MojoExecutionException {
        if (!name.endsWith(".class")) {
            return;
        }
        name = name.substring(0, name.length() - 6);
        name = name.replace('/', '.');
        for (Pattern p : this.patterns) {
            if (!p.matcher(name).matches()) continue;
            this.queue(name, timestamp);
            return;
        }
    }

    private void queue(String className, long timestamp) throws MojoExecutionException {
        JDefinedClass w;
        Class<?> ann;
        this.getLog().debug((CharSequence)("Processing " + className));
        try {
            ann = this.userLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        if (!Annotation.class.isAssignableFrom(ann)) {
            this.getLog().debug((CharSequence)("Skipping " + className + ". Not an annotation"));
            return;
        }
        try {
            w = this.pkg._class(8, QuickGenMojo.getShortName(ann.getName()) + "Quick");
        }
        catch (JClassAlreadyExistsException e) {
            throw new MojoExecutionException("Class name collision on " + className, (Exception)((Object)e));
        }
        Object name = this.pkg.name();
        name = ((String)name).length() == 0 ? QuickGenMojo.getShortName(className) : (String)name + "." + QuickGenMojo.getShortName(className);
        File dst = new File(this.destDir, ((String)name).replace('.', File.separatorChar) + "Quick.java");
        if (dst.exists() && dst.lastModified() > timestamp) {
            this.getLog().debug((CharSequence)("Skipping " + className + ". Up to date."));
            w.hide();
        }
        this.queue.put(ann, w);
    }
}

