/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.maven;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FilterCodeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LicenseCodeWriter
extends FilterCodeWriter {
    private static final String COPYRIGHT_LINE_TEMPLATE = "^.*Copyright \\(c\\) (YYYY) (by )?([A-Za-z].*)$";
    private static final Pattern PATTERN = Pattern.compile("^.*Copyright \\(c\\) (YYYY) (by )?([A-Za-z].*)$", 8);
    private static final String CURRENT_YEAR = String.valueOf(Calendar.getInstance().get(1));
    private final Path license;

    public LicenseCodeWriter(CodeWriter core, File license, String encoding) {
        super(core);
        this.license = license.toPath();
        this.encoding = encoding;
    }

    public Writer openSource(JPackage pkg, String fileName) throws IOException {
        Writer w = super.openSource(pkg, fileName);
        PrintWriter out = new PrintWriter(w);
        try (BufferedReader br = Files.newBufferedReader(this.license, Charset.forName(this.encoding));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = PATTERN.matcher(line);
                if (m.matches()) {
                    out.write(line, 0, m.start(1));
                    out.write(CURRENT_YEAR);
                    out.write(line, m.end(1), line.length() - m.end(1));
                } else {
                    out.write(line);
                }
                out.write(System.lineSeparator());
            }
        }
        out.flush();
        return w;
    }
}

