/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.build;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.FilterCodeWriter;
import com.sun.istack.build.NameConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ResourceGenTask
extends Task {
    private FileSet resources;
    private File destDir;
    private File license;
    private String localizationUtilitiesPkgName;
    private String encoding;

    public void addConfiguredResource(FileSet fs) {
        this.resources = fs;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void setLicense(File license) {
        this.license = license;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLocalizationUtilitiesPkgName(String localizationUtilitiesPkgName) {
        this.localizationUtilitiesPkgName = localizationUtilitiesPkgName;
    }

    public void execute() throws BuildException {
        if (this.resources == null) {
            throw new BuildException("No resource file is specified");
        }
        if (this.destDir == null) {
            throw new BuildException("No destdir attribute is specified");
        }
        if (this.localizationUtilitiesPkgName == null) {
            this.localizationUtilitiesPkgName = "com.sun.istack.localization";
        }
        if (!this.destDir.exists() && !this.destDir.mkdirs()) {
            throw new BuildException("Cannot create destdir");
        }
        if (!this.destDir.canWrite()) {
            throw new BuildException("Cannot write to destdir");
        }
        if (this.encoding == null || this.encoding.trim().length() == 0) {
            this.encoding = System.getProperty("file.encoding");
            this.log("File encoding has not been set, using platform encoding " + this.encoding + ", i.e. build is platform dependent!", 1);
        }
        JCodeModel cm = new JCodeModel();
        DirectoryScanner ds = this.resources.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String value : includedFiles) {
            JClass lable_class;
            JClass l_class;
            JClass lmf_class;
            JDefinedClass clazz;
            File res = new File(baseDir, value);
            if (res.getName().contains("_")) continue;
            String className = this.getClassName(res);
            String bundleName = value.substring(0, value.lastIndexOf(46)).replace('/', '.').replace('\\', '.');
            String dirName = bundleName.substring(0, bundleName.lastIndexOf(46));
            File destFile = new File(new File(this.destDir, dirName.replace('.', '/')), className + ".java");
            if (destFile.lastModified() >= res.lastModified()) {
                this.log("Skipping " + res, 2);
                continue;
            }
            this.log("Processing " + res, 2);
            JPackage pkg = cm._package(dirName);
            Properties props = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(res);
                props.load(in);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        throw new BuildException(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
            try {
                clazz = pkg._class(9, className);
            }
            catch (JClassAlreadyExistsException e) {
                throw new BuildException("Name conflict " + className);
            }
            clazz.javadoc().add((Object)"Defines string formatting method for each constant in the resource file");
            try {
                lmf_class = cm.parseType(this.addLocalizationUtilityPackageName("LocalizableMessageFactory")).boxify();
                l_class = cm.parseType(this.addLocalizationUtilityPackageName("Localizer")).boxify();
                lable_class = cm.parseType(this.addLocalizationUtilityPackageName("Localizable")).boxify();
            }
            catch (Throwable e) {
                throw new BuildException(e);
            }
            JFieldVar $msgFactory = clazz.field(28, (JType)lmf_class, "messageFactory", (JExpression)JExpr._new((JClass)lmf_class).arg(JExpr.lit((String)bundleName)));
            JFieldVar $localizer = clazz.field(28, (JType)l_class, "localizer", (JExpression)JExpr._new((JClass)l_class));
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String methodBaseName = NameConverter.smart.toConstantName(e.getKey().toString());
                JMethod method = clazz.method(17, (JType)lable_class, "localizable" + methodBaseName);
                int countArgs = this.countArgs(e.getValue().toString());
                JInvocation format = $msgFactory.invoke("getMessage").arg(JExpr.lit((String)e.getKey().toString()));
                for (int i = 0; i < countArgs; ++i) {
                    format.arg((JExpression)method.param(Object.class, "arg" + i));
                }
                method.body()._return((JExpression)format);
                JMethod method2 = clazz.method(17, String.class, methodBaseName);
                method2.javadoc().add(e.getValue());
                JInvocation localize = JExpr.invoke((JMethod)method);
                for (int i = 0; i < countArgs; ++i) {
                    localize.arg((JExpression)method2.param(Object.class, "arg" + i));
                }
                method2.body()._return((JExpression)$localizer.invoke("localize").arg((JExpression)localize));
            }
        }
        try {
            Object core = new FileCodeWriter(this.destDir, this.encoding);
            if (this.license != null) {
                core = new LicenseCodeWriter((CodeWriter)core, this.license, this.encoding);
            }
            cm.build((CodeWriter)core);
        }
        catch (IOException e) {
            throw new BuildException("Failed to generate code", (Throwable)e);
        }
    }

    private String addLocalizationUtilityPackageName(String className) {
        return String.format("%s.%s", this.localizationUtilitiesPkgName, className);
    }

    private int countArgs(String value) {
        String r2;
        String r1;
        ArrayList<String> x = new ArrayList<String>();
        do {
            r1 = MessageFormat.format(value, x.toArray());
            x.add("xxxx");
        } while (!r1.equals(r2 = MessageFormat.format(value, x.toArray())));
        return x.size() - 1;
    }

    private String getClassName(File res) {
        String name = res.getName();
        int suffixIndex = name.lastIndexOf(46);
        name = name.substring(0, suffixIndex);
        return NameConverter.smart.toClassName(name) + "Messages";
    }

    public static class LicenseCodeWriter
    extends FilterCodeWriter {
        private final File license;

        public LicenseCodeWriter(CodeWriter core, File license, String encoding) {
            super(core);
            this.license = license;
            this.encoding = encoding;
        }

        public Writer openSource(JPackage pkg, String fileName) throws IOException {
            Writer w = super.openSource(pkg, fileName);
            PrintWriter out = new PrintWriter(w);
            try (FileInputStream fin = new FileInputStream(this.license);){
                int len;
                byte[] buf = new byte[8192];
                while ((len = fin.read(buf)) != -1) {
                    out.write(new String(buf, 0, len));
                }
            }
            out.flush();
            return w;
        }
    }
}

