/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.istack.maven;

import com.oracle.istack.maven.CommonLogger;
import com.oracle.istack.maven.DependencyResolver;
import com.oracle.istack.maven.ImportPropertiesMojo;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

public class PropertyResolver {
    private final CommonLogger logger;
    private final MavenXpp3Reader mavenreader = new MavenXpp3Reader();
    private final Properties properties;
    private final RepositorySystemSession repoSession;
    private final RepositorySystem repoSystem;
    private final List<RemoteRepository> pluginRepos;

    PropertyResolver(CommonLogger logger, Properties properties, RepositorySystemSession session, RepositorySystem repoSystem, List<RemoteRepository> pluginRepositories) {
        this.logger = logger;
        this.properties = properties;
        this.repoSession = session;
        this.repoSystem = repoSystem;
        this.pluginRepos = pluginRepositories;
    }

    public void resolveProperties(MavenProject project) throws FileNotFoundException, IOException, XmlPullParserException {
        FileReader reader;
        this.logger.info("Resolving properties for " + project.getGroupId() + ":" + project.getArtifactId());
        Model model = null;
        try {
            reader = new FileReader(project.getFile());
            model = this.mavenreader.read((Reader)reader);
        }
        catch (IOException ex) {
            Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
        MavenProject loadedProject = new MavenProject(model);
        DependencyManagement dm = loadedProject.getDependencyManagement();
        if (dm == null) {
            this.logger.warn("No dependency management section found in: " + loadedProject.getGroupId() + ":" + loadedProject.getArtifactId());
            return;
        }
        List depList = dm.getDependencies();
        for (Dependency d : depList) {
            if (!"import".equals(d.getScope())) continue;
            try {
                String version = d.getVersion();
                this.logger.info("Imported via import-scope: " + d.getGroupId() + ":" + d.getArtifactId() + ":" + version);
                if (version.contains("$")) {
                    version = this.properties.getProperty(version.substring(version.indexOf(123) + 1, version.lastIndexOf(125)));
                    this.logger.info("Imported version resolved to: " + version);
                }
                d.setVersion(version);
                d.setType("pom");
                d.setClassifier("pom");
                DependencyResult result = DependencyResolver.resolve(d, this.pluginRepos, this.repoSystem, this.repoSession);
                Artifact a = ((ArtifactResult)result.getArtifactResults().get(0)).getArtifact();
                reader = new FileReader(a.getFile());
                Model m = this.mavenreader.read((Reader)reader);
                MavenProject p = new MavenProject(m);
                p.setFile(a.getFile());
                for (Map.Entry<Object, Object> e : p.getProperties().entrySet()) {
                    this.logger.info("Setting property: " + e.getKey() + ":" + e.getValue());
                    this.properties.setProperty((String)e.getKey(), (String)e.getValue());
                }
                this.resolveProperties(p);
            }
            catch (DependencyResolutionException ex) {
                Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

