/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.AbstractThreadPool;
import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.ThreadPoolMonitoringProbe;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedThreadPool
extends AbstractThreadPool {
    private int expectedWorkerCount;
    protected final BlockingQueue<Runnable> workQueue;

    public FixedThreadPool() {
        this(8);
    }

    public FixedThreadPool(int size) {
        this(size, FixedThreadPool.class.getSimpleName());
    }

    public FixedThreadPool(int poolsize, String name) {
        this(name, poolsize, DataStructures.getLTQinstance(Runnable.class), null);
    }

    public FixedThreadPool(int poolsize, ThreadFactory threadfactory) {
        this(poolsize, DataStructures.getLTQinstance(Runnable.class), threadfactory);
    }

    public FixedThreadPool(int poolsize, BlockingQueue<Runnable> workQueue, ThreadFactory threadfactory) {
        this(FixedThreadPool.class.getSimpleName(), poolsize, workQueue, threadfactory);
    }

    public FixedThreadPool(String name, int poolsize, BlockingQueue<Runnable> workQueue, ThreadFactory threadfactory) {
        this(name, poolsize, workQueue, threadfactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedThreadPool(String name, int poolsize, BlockingQueue<Runnable> workQueue, ThreadFactory threadfactory, ThreadPoolMonitoringProbe probe) {
        super(probe, name, threadfactory, poolsize);
        this.workQueue = workQueue != null ? workQueue : DataStructures.getLTQinstance(Runnable.class);
        Object object = this.statelock;
        synchronized (object) {
            while (poolsize-- > 0) {
                this.doStartWorker();
            }
        }
        super.onMaxNumberOfThreadsReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize < 1) {
            throw new IllegalStateException("maximumPoolSize < 1");
        }
        Object object = this.statelock;
        synchronized (object) {
            if (this.running) {
                int toAdd;
                this.maxPoolSize = maximumPoolSize;
                for (toAdd = maximumPoolSize - this.expectedWorkerCount; toAdd > 0; --toAdd) {
                    this.doStartWorker();
                }
                while (toAdd++ < 0) {
                    this.workQueue.add(poison);
                    --this.expectedWorkerCount;
                }
                super.onMaxNumberOfThreadsReached();
            }
        }
    }

    private void doStartWorker() {
        this.startWorker(new BasicWorker());
        ++this.expectedWorkerCount;
    }

    @Override
    public void execute(Runnable command) {
        if (this.running) {
            if (this.workQueue.offer(command)) {
                this.onTaskQueued(command);
                return;
            }
            this.onTaskQueueOverflow();
            return;
        }
        throw new RejectedExecutionException("ThreadPool is not running");
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getActiveCount() {
        return 0;
    }

    @Override
    public int getTaskCount() {
        return 0;
    }

    @Override
    public long getCompletedTaskCount() {
        return 0L;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
    }

    @Override
    public int getLargestPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int getPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public Queue<Runnable> getQueue() {
        return this.workQueue;
    }

    @Override
    public int getQueueSize() {
        return this.workQueue.size();
    }

    @Override
    public int getMaxQueuedTasksCount() {
        return -1;
    }

    @Override
    public void setMaxQueuedTasksCount(int maxTasksCount) {
    }

    private final class BasicWorker
    extends AbstractThreadPool.Worker {
        private BasicWorker() {
        }

        protected final Runnable getTask() throws InterruptedException {
            return FixedThreadPool.this.workQueue.take();
        }
    }
}

