/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.osgi.httpservice;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.osgi.httpservice.HttpServiceFactory;
import com.sun.grizzly.osgi.httpservice.util.Logger;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private ServiceTracker logTracker;
    private ServiceRegistration registration;
    private Logger logger;
    private GrizzlyWebServer ws;
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final String ORG_OSGI_SERVICE_HTTPS_PORT = "org.osgi.service.http.port.secure";
    private HttpServiceFactory serviceFactory;
    private static final String COM_SUN_GRIZZLY_COMET_SUPPORT = "com.sun.grizzly.cometSupport";

    public void start(BundleContext bundleContext) throws Exception {
        this.logTracker = new ServiceTracker(bundleContext, LogService.class.getName(), null);
        this.logTracker.open();
        this.logger = new Logger(this.logTracker);
        this.logger.info("Starting Grizzly OSGi HttpService");
        int port = this.readProperty(bundleContext, ORG_OSGI_SERVICE_HTTP_PORT, 80);
        if (bundleContext.getProperty(ORG_OSGI_SERVICE_HTTPS_PORT) != null) {
            this.logger.warn("HTTPS not supported yet.");
        }
        boolean cometEnabled = this.readProperty(bundleContext, COM_SUN_GRIZZLY_COMET_SUPPORT, false);
        this.startGrizzly(port, cometEnabled);
        this.serviceFactory = new HttpServiceFactory(this.ws, this.logger, bundleContext.getBundle());
        this.registration = bundleContext.registerService(HttpService.class.getName(), (Object)this.serviceFactory, (Dictionary)new Properties());
    }

    private <T> T readProperty(BundleContext ctx, String name, T defValue) {
        String value = ctx.getProperty(name);
        if (value != null) {
            if (defValue instanceof Integer) {
                try {
                    return (T)Integer.valueOf(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    this.logger.info("Couldn't parse '" + name + "' property, going to use default (" + defValue + "). " + e.getMessage());
                }
            } else if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(value));
            }
            return (T)value;
        }
        return defValue;
    }

    private void startGrizzly(int port, boolean cometEnabled) throws IOException {
        this.ws = new GrizzlyWebServer(port);
        if (cometEnabled) {
            this.logger.info("Enabling Comet.");
            SelectorThread st = this.ws.getSelectorThread();
            st.setEnableAsyncExecution(true);
            DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
            asyncHandler.addAsyncFilter(new CometAsyncFilter());
            st.setAsyncHandler(asyncHandler);
        }
        this.ws.setMaxThreads(5);
        this.ws.useAsynchronousWrite(true);
        this.ws.start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.logger.info("Stopping Grizzly OSGi HttpService");
        this.serviceFactory.stop();
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.ws.stop();
        this.logTracker.close();
    }
}

