/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.deployer;

import com.sun.grizzly.http.deployer.DeployException;
import com.sun.grizzly.http.deployer.Deployable;
import com.sun.grizzly.http.deployer.DeploymentConfiguration;
import com.sun.grizzly.http.deployer.DeploymentID;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Deployer<V extends Deployable, T extends DeploymentConfiguration> {
    private static final Logger logger = Logger.getLogger("com.sun.grizzly.http.deployer.Deployer");
    private Map<DeploymentID, Set<GrizzlyAdapter>> deployed = new HashMap<DeploymentID, Set<GrizzlyAdapter>>();

    public final DeploymentID deploy(GrizzlyWebServer gws, V toDeploy, T configuration) throws DeployException {
        Map<GrizzlyAdapter, Set<String>> map = this.convert(toDeploy, configuration);
        if (map == null || map.isEmpty()) {
            throw new DeployException("No GrizzlyAdapters created for: " + toDeploy);
        }
        for (Map.Entry<GrizzlyAdapter, Set<String>> adapterEntry : map.entrySet()) {
            GrizzlyAdapter adapter = adapterEntry.getKey();
            Set<String> mappings = adapterEntry.getValue();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, String.format("Deploying '%s' to %s", adapter, mappings));
            }
            gws.addGrizzlyAdapter(adapter, mappings.toArray(new String[mappings.size()]));
        }
        DeploymentID deploymentId = new DeploymentID(toDeploy.hashCode());
        this.deployed.put(deploymentId, map.keySet());
        return deploymentId;
    }

    public final void undeploy(GrizzlyWebServer gws, DeploymentID deploymentId) {
        Set<GrizzlyAdapter> adapters = this.deployed.get(deploymentId);
        for (GrizzlyAdapter adapter : adapters) {
            gws.removeGrizzlyAdapter(adapter);
        }
    }

    protected abstract Map<GrizzlyAdapter, Set<String>> convert(V var1, T var2) throws DeployException;
}

