/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.http.Constants;
import com.sun.grizzly.http.FileCache;
import com.sun.grizzly.http.FileCacheFactory;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.buf.Ascii;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.IOException;
import java.nio.channels.SocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticHandler
implements Interceptor<Request> {
    private SocketChannel socketChannel;
    protected FileCache fileCache;

    public void attachChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        if (this.fileCache == null && socketChannel != null) {
            this.fileCache = FileCacheFactory.getFactory(socketChannel.socket().getLocalPort()).getFileCache();
        }
    }

    public int handle(Request req, int handlerCode) throws IOException {
        ByteChunk requestURI;
        if (this.fileCache == null) {
            return 0;
        }
        if (handlerCode == 1 && this.fileCache.isEnabled()) {
            String docroot = SelectorThread.getWebAppRootPath();
            MessageBytes mb = req.requestURI();
            ByteChunk requestURI2 = mb.getByteChunk();
            String uri = req.requestURI().toString();
            this.fileCache.add("default", docroot, uri, req.getResponse().getMimeHeaders(), false);
        } else if (handlerCode == 0 && this.fileCache.sendCache((requestURI = req.requestURI().getByteChunk()).getBytes(), requestURI.getStart(), requestURI.getLength(), this.socketChannel, this.keepAlive(req))) {
            return 1;
        }
        return 0;
    }

    private boolean keepAlive(Request request) {
        MimeHeaders headers = request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                return false;
            }
            if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                return true;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower((int)buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower((int)buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }
}

