/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SecureSelector;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.ssl.SSLAsyncProcessorTask;
import com.sun.grizzly.ssl.SSLAsyncProtocolFilter;
import com.sun.grizzly.ssl.SSLDefaultProcessorTask;
import com.sun.grizzly.ssl.SSLDefaultProtocolFilter;
import com.sun.grizzly.ssl.SSLFileCacheFactory;
import com.sun.grizzly.ssl.SSLSelectorThreadHandler;
import com.sun.grizzly.util.net.SSLImplementation;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLSelectorThread
extends SelectorThread
implements SecureSelector<SSLImplementation> {
    private SSLImplementation sslImplementation;
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;

    @Override
    protected TCPSelectorHandler createSelectorHandler() {
        return new SSLSelectorThreadHandler(this);
    }

    private ProtocolFilter createHttpParserFilter() {
        if (this.asyncExecution) {
            return new SSLAsyncProtocolFilter(this.algorithmClass, this.port, this.sslImplementation);
        }
        return new SSLDefaultProtocolFilter(this.algorithmClass, this.port, this.sslImplementation);
    }

    private ProtocolFilter createSSLReadFilter() {
        SSLReadFilter readFilter = new SSLReadFilter();
        readFilter.setSSLContext(this.sslContext);
        readFilter.setClientMode(this.clientMode);
        readFilter.setEnabledCipherSuites(this.enabledCipherSuites);
        readFilter.setEnabledProtocols(this.enabledProtocols);
        readFilter.setNeedClientAuth(this.needClientAuth);
        readFilter.setWantClientAuth(this.wantClientAuth);
        return readFilter;
    }

    @Override
    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            this.portUnificationFilter.setContinuousExecution(true);
            protocolChain.addFilter((ProtocolFilter)this.portUnificationFilter);
        }
        protocolChain.addFilter(this.createSSLReadFilter());
        if (this.rcmSupport) {
            protocolChain.addFilter(this.createRaFilter());
        }
        protocolChain.addFilter(this.createHttpParserFilter());
    }

    @Override
    protected ProcessorTask newProcessorTask(boolean initialize) {
        SSLDefaultProcessorTask task = null;
        task = !this.asyncExecution ? new SSLDefaultProcessorTask(initialize, this.isBufferResponse()) : new SSLAsyncProcessorTask(initialize, this.isBufferResponse());
        return this.configureProcessorTask(task);
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    @Override
    public boolean isClientMode() {
        return this.clientMode;
    }

    @Override
    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    @Override
    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    @Override
    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    @Override
    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    @Override
    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    @Override
    protected void initFileCacheFactory() {
        SSLFileCacheFactory.setIsEnabled(this.isFileCacheEnabled);
        this.fileCacheFactory = SSLFileCacheFactory.getFactory(this.port);
        this.fileCacheFactory.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
        this.fileCacheFactory.setSecondsMaxAge(this.secondsMaxAge);
        this.fileCacheFactory.setMaxCacheEntries(this.maxCacheEntries);
        this.fileCacheFactory.setMinEntrySize(this.minEntrySize);
        this.fileCacheFactory.setMaxEntrySize(this.maxEntrySize);
        this.fileCacheFactory.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
        this.fileCacheFactory.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
        this.fileCacheFactory.setIsMonitoringEnabled(this.isMonitoringEnabled);
    }
}

