/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.SSLUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class SSLAsyncStream
extends ByteBufferInputStream {
    private SSLEngine sslEngine;
    private ByteBuffer inputBB;

    protected int doRead() {
        this.byteBuffer.compact();
        int initialPosition = this.byteBuffer.position();
        int byteRead = 0;
        while (this.byteBuffer.position() == initialPosition && (byteRead += SSLUtils.doRead((SelectableChannel)((SocketChannel)this.key.channel()), (ByteBuffer)this.inputBB, (SSLEngine)this.sslEngine, (int)this.readTimeout)) > 0) {
            try {
                this.byteBuffer = SSLUtils.unwrapAll((ByteBuffer)this.byteBuffer, (ByteBuffer)this.inputBB, (SSLEngine)this.sslEngine);
            }
            catch (IOException ex) {
                Logger logger = SSLSelectorThread.logger();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "SSLUtils.unwrapAll", ex);
                }
                return -1;
            }
        }
        this.byteBuffer.flip();
        return byteRead;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }
}

