/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.Grizzly;
import com.sun.grizzly.ProcessorExecutor;
import com.sun.grizzly.Transport;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public class WorkerThreadExecutor
implements ProcessorExecutor {
    private Transport transport;

    public WorkerThreadExecutor(Transport transport) {
        this.transport = transport;
    }

    @Override
    public void execute(Runnable task) {
        try {
            this.transport.getWorkerThreadPool().submit(task);
        }
        catch (RejectedExecutionException e) {
            if (!this.transport.isStopped()) {
                Grizzly.logger.log(Level.WARNING, "Task " + task + " was rejected by ThreadPool. Reason: ", e);
            }
            Grizzly.logger.log(Level.FINE, "Task " + task + " was rejected by ThreadPool. Reason: ", e);
        }
    }

    @Override
    public boolean isCurrentThreadExecutor() {
        return false;
    }
}

