/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.strategies;

import com.sun.grizzly.Connection;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.ProcessorRunnable;
import com.sun.grizzly.Strategy;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.NIOTransport;
import com.sun.grizzly.strategies.LeaderFollowerStrategy;
import com.sun.grizzly.strategies.SameThreadStrategy;
import com.sun.grizzly.strategies.WorkerThreadStrategy;
import com.sun.grizzly.utils.CurrentThreadExecutor;
import com.sun.grizzly.utils.WorkerThreadExecutor;
import java.io.IOException;
import java.util.concurrent.Executor;

public class SimpleDynamicStrategy
implements Strategy<DynamicStrategyContext> {
    private SameThreadStrategy sameThreadStrategy = new SameThreadStrategy();
    private LeaderFollowerStrategy leaderFollowerStrategy;
    private WorkerThreadStrategy workerThreadStrategy;
    private int leaderFollowerThreshold = 1;
    private int workerThreadThreshold = 32;

    public SimpleDynamicStrategy(NIOTransport transport) {
        this(new CurrentThreadExecutor(), new WorkerThreadExecutor(transport));
    }

    public SimpleDynamicStrategy(Executor sameThreadProcessorExecutor, Executor workerThreadProcessorExecutor) {
        this.leaderFollowerStrategy = new LeaderFollowerStrategy(sameThreadProcessorExecutor, workerThreadProcessorExecutor);
        this.workerThreadStrategy = new WorkerThreadStrategy(sameThreadProcessorExecutor, workerThreadProcessorExecutor);
    }

    @Override
    public DynamicStrategyContext prepare(Connection connection, IOEvent ioEvent) {
        return new DynamicStrategyContext(((NIOConnection)connection).getSelectorRunner().getLastSelectedKeysCount());
    }

    @Override
    public void executeProcessor(DynamicStrategyContext strategyContext, ProcessorRunnable processorRunnable) throws IOException {
        if (strategyContext == null) {
            this.workerThreadStrategy.executeProcessor(strategyContext, processorRunnable);
            return;
        }
        int lastSelectedKeysCount = strategyContext.lastSelectedKeysCount;
        if (lastSelectedKeysCount >= this.workerThreadThreshold) {
            this.workerThreadStrategy.executeProcessor(strategyContext, processorRunnable);
        } else if (lastSelectedKeysCount >= this.leaderFollowerThreshold) {
            strategyContext.isTerminateThread = true;
            this.leaderFollowerStrategy.executeProcessor(strategyContext.isTerminateThread, processorRunnable);
        } else {
            this.sameThreadStrategy.executeProcessor(strategyContext, processorRunnable);
        }
    }

    @Override
    public boolean isTerminateThread(DynamicStrategyContext strategyContext) {
        return strategyContext.isTerminateThread;
    }

    public int getLeaderFollowerThreshold() {
        return this.leaderFollowerThreshold;
    }

    public void setLeaderFollowerThreshold(int leaderFollowerThreshold) {
        this.leaderFollowerThreshold = leaderFollowerThreshold;
        this.checkThresholds();
    }

    public int getWorkerThreadThreshold() {
        return this.workerThreadThreshold;
    }

    public void setWorkerThreadThreshold(int workerThreadThreshold) {
        this.workerThreadThreshold = workerThreadThreshold;
        this.checkThresholds();
    }

    private void checkThresholds() {
        if (this.leaderFollowerThreshold >= 0 && this.workerThreadThreshold >= this.leaderFollowerThreshold) {
            return;
        }
        throw new IllegalStateException("Thresholds settings are incorrect");
    }

    public static final class DynamicStrategyContext {
        final int lastSelectedKeysCount;
        boolean isTerminateThread;

        public DynamicStrategyContext(int lastSelectedKeysCount) {
            this.lastSelectedKeysCount = lastSelectedKeysCount;
        }
    }
}

