/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.strategies;

import com.sun.grizzly.Connection;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.ProcessorRunnable;
import com.sun.grizzly.Strategy;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.NIOTransport;
import com.sun.grizzly.nio.SelectorRunner;
import com.sun.grizzly.utils.CurrentThreadExecutor;
import com.sun.grizzly.utils.WorkerThreadExecutor;
import java.io.IOException;
import java.util.concurrent.Executor;

public class LeaderFollowerStrategy
implements Strategy<Boolean> {
    private Executor sameThreadProcessorExecutor;
    private Executor workerThreadProcessorExecutor;

    public LeaderFollowerStrategy(NIOTransport transport) {
        this(new CurrentThreadExecutor(), new WorkerThreadExecutor(transport));
    }

    public LeaderFollowerStrategy(Executor sameThreadProcessorExecutor, Executor workerThreadProcessorExecutor) {
        this.sameThreadProcessorExecutor = sameThreadProcessorExecutor;
        this.workerThreadProcessorExecutor = workerThreadProcessorExecutor;
    }

    @Override
    public Boolean prepare(Connection connection, IOEvent ioEvent) {
        return true;
    }

    @Override
    public void executeProcessor(Boolean strategyContext, ProcessorRunnable processorRunnable) throws IOException {
        if (strategyContext != null && strategyContext.booleanValue()) {
            NIOConnection nioConnection = (NIOConnection)processorRunnable.getConnection();
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            nioConnection.getTransport().getWorkerThreadPool().execute(runner);
        }
        Executor executor = this.getProcessorExecutor(strategyContext);
        executor.execute(processorRunnable);
    }

    @Override
    public boolean isTerminateThread(Boolean strategyContext) {
        return strategyContext;
    }

    public Executor getProcessorExecutor(Boolean strategyContext) {
        if (strategyContext != null && strategyContext.booleanValue()) {
            return this.sameThreadProcessorExecutor;
        }
        return this.workerThreadProcessorExecutor;
    }
}

