/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeBuilder;
import com.sun.grizzly.attributes.AttributeHolder;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.memory.MemoryManager;
import com.sun.grizzly.threadpool.WorkerThread;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLResourcesAccessor {
    public static final String SSL_ENGINE_ATTR_NAME = "SSLEngineAttr";
    public static final String SSL_SECURED_IN_BUFFER_NAME = "thread-buffer";
    public static final String SSL_SECURED_OUT_BUFFER_NAME = "SSLOutputBufferAttr";
    public static final String SSL_APP_BUFFER_NAME = "SSLPlainBufferAttr";
    private static final SSLResourcesAccessor instance = new SSLResourcesAccessor().initializeAttributes();
    public Attribute<SSLEngine> sslEngineAttribute;
    public Attribute<Buffer> plainBufferAttribute;
    public Attribute<Buffer> sslSecuredInBufferAttribute;
    public Attribute<Buffer> sslSecuredOutBufferAttribute;

    public static SSLResourcesAccessor getInstance() {
        return instance;
    }

    protected SSLResourcesAccessor initializeAttributes() {
        AttributeBuilder attrBuilder = this.getAttributeBuilder();
        this.sslEngineAttribute = attrBuilder.createAttribute(SSL_ENGINE_ATTR_NAME);
        this.sslSecuredInBufferAttribute = attrBuilder.createAttribute(SSL_SECURED_IN_BUFFER_NAME);
        this.sslSecuredOutBufferAttribute = attrBuilder.createAttribute(SSL_SECURED_OUT_BUFFER_NAME);
        this.plainBufferAttribute = attrBuilder.createAttribute(SSL_APP_BUFFER_NAME);
        return this;
    }

    protected AttributeBuilder getAttributeBuilder() {
        return Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
    }

    public SSLEngine getSSLEngine(AttributeStorage state) {
        return this.sslEngineAttribute.get(state);
    }

    public SSLEngine obtainSSLEngine(SSLContext sslContext, AttributeStorage state) {
        SSLResourcesAccessor stateController = SSLResourcesAccessor.getInstance();
        SSLEngine engine = stateController.getSSLEngine(state);
        if (engine == null) {
            engine = sslContext.createSSLEngine();
            stateController.setSSLEngine(state, engine);
        }
        return engine;
    }

    public void setSSLEngine(AttributeStorage state, SSLEngine sslEngine) {
        this.sslEngineAttribute.set(state, sslEngine);
    }

    public Buffer getAppBuffer(AttributeStorage state) {
        return this.plainBufferAttribute.get(state);
    }

    public Buffer obtainAppBuffer(AttributeStorage state) {
        Buffer<Object> buffer = this.getAppBuffer(state);
        if (buffer != null) {
            return buffer;
        }
        Thread currentThread = Thread.currentThread();
        boolean isWorkingThread = currentThread instanceof WorkerThread;
        if (isWorkingThread) {
            WorkerThread workerThread = (WorkerThread)((Object)currentThread);
            buffer = this.getAppBuffer(workerThread);
        }
        SSLEngine sslEngine = this.getSSLEngine(state);
        assert (sslEngine != null);
        if (buffer == null) {
            if (state instanceof Connection) {
                MemoryManager memoryManager = ((Connection)state).getTransport().getMemoryManager();
                buffer = memoryManager.allocate(sslEngine.getSession().getApplicationBufferSize());
                return buffer;
            }
            return null;
        }
        if (buffer.capacity() < sslEngine.getSession().getApplicationBufferSize()) {
            if (state instanceof Connection) {
                MemoryManager memoryManager = ((Connection)state).getTransport().getMemoryManager();
                buffer.dispose();
                buffer = memoryManager.allocate(sslEngine.getSession().getApplicationBufferSize());
            } else {
                return null;
            }
        }
        if (isWorkingThread) {
            WorkerThread workerThread = (WorkerThread)((Object)currentThread);
            this.setAppBuffer(workerThread, buffer);
        } else {
            this.setAppBuffer(state, buffer);
        }
        return buffer;
    }

    public void setAppBuffer(AttributeStorage state, Buffer buffer) {
        this.plainBufferAttribute.set(state, buffer);
    }

    public Buffer getSecuredInBuffer(AttributeStorage state) {
        return this.sslSecuredInBufferAttribute.get(state);
    }

    public Buffer obtainSecuredInBuffer(AttributeStorage state) {
        MemoryManager memoryManager;
        Buffer<Object> buffer = this.getSecuredInBuffer(state);
        if (buffer != null) {
            return buffer;
        }
        Thread currentThread = Thread.currentThread();
        boolean isWorkingThread = currentThread instanceof WorkerThread;
        if (isWorkingThread) {
            WorkerThread workerThread = (WorkerThread)((Object)currentThread);
            buffer = this.getSecuredInBuffer(workerThread);
        }
        SSLEngine sslEngine = this.getSSLEngine(state);
        assert (sslEngine != null);
        if (buffer == null) {
            if (state instanceof Connection) {
                memoryManager = ((Connection)state).getTransport().getMemoryManager();
                buffer = memoryManager.allocate(sslEngine.getSession().getPacketBufferSize());
                buffer.flip();
            } else {
                return null;
            }
        }
        if (buffer.capacity() < sslEngine.getSession().getPacketBufferSize()) {
            if (state instanceof Connection) {
                memoryManager = ((Connection)state).getTransport().getMemoryManager();
                Object newBuffer = memoryManager.allocate(sslEngine.getSession().getPacketBufferSize());
                newBuffer.put(buffer);
                buffer.dispose();
                buffer = newBuffer.flip();
            } else {
                return null;
            }
        }
        if (isWorkingThread) {
            WorkerThread workerThread = (WorkerThread)((Object)currentThread);
            this.setSecuredInBuffer(workerThread, buffer);
        } else {
            this.setSecuredInBuffer(state, buffer);
        }
        return buffer;
    }

    public void setSecuredInBuffer(AttributeStorage state, Buffer buffer) {
        this.sslSecuredInBufferAttribute.set(state, buffer);
    }

    public Buffer getSecuredOutBuffer(AttributeStorage state) {
        return this.sslSecuredOutBufferAttribute.get(state);
    }

    public Buffer obtainSecuredOutBuffer(AttributeStorage state) {
        Buffer<Object> buffer = this.getSecuredOutBuffer(state);
        if (buffer != null) {
            return buffer;
        }
        Thread currentThread = Thread.currentThread();
        boolean isWorkingThread = currentThread instanceof WorkerThread;
        if (isWorkingThread) {
            WorkerThread workerThread = (WorkerThread)((Object)currentThread);
            buffer = this.getSecuredOutBuffer(workerThread);
        }
        SSLEngine sslEngine = this.getSSLEngine(state);
        assert (sslEngine != null);
        if (buffer == null) {
            if (state instanceof Connection) {
                MemoryManager memoryManager = ((Connection)state).getTransport().getMemoryManager();
                buffer = memoryManager.allocate(sslEngine.getSession().getPacketBufferSize());
                return buffer;
            }
            return null;
        }
        if (buffer.capacity() < sslEngine.getSession().getPacketBufferSize()) {
            if (state instanceof Connection) {
                MemoryManager memoryManager = ((Connection)state).getTransport().getMemoryManager();
                buffer.dispose();
                buffer = memoryManager.allocate(sslEngine.getSession().getPacketBufferSize());
            } else {
                return null;
            }
        }
        if (isWorkingThread) {
            WorkerThread workerThread = (WorkerThread)((Object)currentThread);
            this.setSecuredOutBuffer(workerThread, buffer);
        } else {
            this.setSecuredOutBuffer(state, buffer);
        }
        return buffer;
    }

    public void setSecuredOutBuffer(AttributeStorage state, Buffer buffer) {
        this.sslSecuredOutBufferAttribute.set(state, buffer);
    }

    public void clear(AttributeStorage state) {
        AttributeHolder attributeHolder = state.getAttributes();
        if (attributeHolder != null) {
            this.sslEngineAttribute.remove(attributeHolder);
            this.plainBufferAttribute.remove(attributeHolder);
            this.sslSecuredInBufferAttribute.remove(attributeHolder);
            this.sslSecuredOutBufferAttribute.remove(attributeHolder);
        }
    }
}

