/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.TransformationException;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.Transformer;
import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeHolder;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.ssl.SSLResourcesAccessor;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SSLDecoderTransformer
implements Transformer<Buffer, Buffer> {
    public static final int NEED_HANDSHAKE_ERROR = 1;
    public static final int BUFFER_UNDERFLOW_ERROR = 2;
    public static final int BUFFER_OVERFLOW_ERROR = 3;
    private Logger logger = Grizzly.logger;
    private static Attribute<TransformationResult<Buffer>> lastResultAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLDecoderTransformer.lastResult");

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage state) throws TransformationException {
        return this.transform(state, this.getInput(state), this.getOutput(state));
    }

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage state, Buffer originalMessage, Buffer targetMessage) throws TransformationException {
        SSLResourcesAccessor resourceAccessor = SSLResourcesAccessor.getInstance();
        SSLEngine sslEngine = resourceAccessor.getSSLEngine(state);
        if (sslEngine == null) {
            throw new IllegalStateException("There is no SSLEngine associated! May be handshake phase was not executed?");
        }
        if (originalMessage == null) {
            originalMessage = this.getInput(state);
        }
        if (targetMessage == null) {
            targetMessage = this.getOutput(state);
        }
        TransformationResult<Buffer> transformationResult = null;
        SSLEngineResult sslEngineResult = null;
        int totalConsumed = 0;
        int totalProduced = 0;
        do {
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("SSLDecoder engine: " + sslEngine + " input: " + originalMessage + " output: " + targetMessage);
                }
                sslEngineResult = sslEngine.unwrap((ByteBuffer)originalMessage.underlying(), (ByteBuffer)targetMessage.underlying());
                totalConsumed += sslEngineResult.bytesConsumed();
                totalProduced += sslEngineResult.bytesProduced();
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine("SSLDecoder done engine: " + sslEngine + " result: " + sslEngineResult + " input: " + originalMessage + " output: " + targetMessage);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "SSLDecoder done engine: " + sslEngine + " result: " + sslEngineResult + " input: " + originalMessage + " output: " + targetMessage, e);
                }
                throw new TransformationException(e);
            }
        } while (originalMessage.hasRemaining() && sslEngineResult.getStatus() == SSLEngineResult.Status.OK);
        SSLEngineResult.Status sslEngineStatus = sslEngineResult.getStatus();
        switch (sslEngineStatus) {
            case OK: {
                if (originalMessage.hasRemaining()) {
                    transformationResult = new TransformationResult(TransformationResult.Status.INCOMPLED, targetMessage.duplicate().flip());
                    break;
                }
            }
            case CLOSED: {
                transformationResult = new TransformationResult(TransformationResult.Status.COMPLETED, targetMessage.duplicate().flip());
                break;
            }
            case BUFFER_UNDERFLOW: {
                transformationResult = new TransformationResult(TransformationResult.Status.INCOMPLED, targetMessage.duplicate().flip());
                break;
            }
            case BUFFER_OVERFLOW: {
                Buffer resultBuffer = targetMessage.duplicate().flip();
                if (totalConsumed > 0 || totalProduced > 0) {
                    targetMessage.clear();
                    transformationResult = new TransformationResult(TransformationResult.Status.INCOMPLED, resultBuffer);
                    break;
                }
                transformationResult = new TransformationResult(3, "Buffer overflow during unwrap operation");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected SSLEngine status: " + (Object)((Object)sslEngineStatus));
            }
        }
        lastResultAttr.set(state.obtainAttributes(), transformationResult);
        return transformationResult;
    }

    @Override
    public Buffer getInput(AttributeStorage state) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        return accessor.obtainSecuredInBuffer(state);
    }

    @Override
    public void setInput(AttributeStorage state, Buffer input) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        accessor.setSecuredInBuffer(state, input);
    }

    @Override
    public Buffer getOutput(AttributeStorage state) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        return accessor.obtainAppBuffer(state);
    }

    @Override
    public void setOutput(AttributeStorage state, Buffer output) {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        accessor.setAppBuffer(state, output);
    }

    @Override
    public TransformationResult<Buffer> getLastResult(AttributeStorage state) {
        AttributeHolder holder = state.getAttributes();
        if (holder != null) {
            return lastResultAttr.get(holder);
        }
        return null;
    }

    @Override
    public AttributeHolder getProperties(AttributeStorage state) {
        return state.getAttributes();
    }

    @Override
    public void hibernate(AttributeStorage state) {
    }

    @Override
    public void release(AttributeStorage state) {
        AttributeHolder holder = state.getAttributes();
        if (holder != null) {
            SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
            accessor.setSecuredInBuffer(state, null);
            accessor.setAppBuffer(state, null);
            lastResultAttr.remove(holder);
        }
    }
}

