/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.smart.transformers;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.smart.SmartTransformer;
import com.sun.grizzly.smart.annotations.CharSequence;
import com.sun.grizzly.smart.transformers.SmartMemberTransformer;
import com.sun.grizzly.utils.StringEncoder;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.List;

public class SmartStringEncoder
extends StringEncoder
implements SmartMemberTransformer<String, Buffer> {
    protected Attribute<List> messageProcessingTreeAttribute;

    public SmartStringEncoder() {
        this((String)null);
    }

    public SmartStringEncoder(String stringTerminator) {
        this(Charset.forName("UTF-8"), null);
    }

    public SmartStringEncoder(Charset charset) {
        this(charset, null);
    }

    public SmartStringEncoder(Charset charset, String stringTerminator) {
        super(charset, stringTerminator);
        this.messageProcessingTreeAttribute = this.attributeBuilder.createAttribute("SmartDecoderTransformer.processingTree");
    }

    @Override
    public void initialize(SmartTransformer parentTransformer, Field field) {
        CharSequence charSequenceAnn = field.getAnnotation(CharSequence.class);
        if (charSequenceAnn != null) {
            String terminateSeqAnn;
            String charsetAnn = charSequenceAnn.charset();
            if (!charsetAnn.equals(this.charset.name())) {
                this.charset = Charset.forName(charsetAnn);
            }
            if ((terminateSeqAnn = charSequenceAnn.terminate()) != null && terminateSeqAnn.length() > 0) {
                this.stringTerminator = terminateSeqAnn;
            }
        }
    }

    @Override
    public List getMessageProcessingTree(AttributeStorage storage) {
        return this.messageProcessingTreeAttribute.get(storage);
    }

    @Override
    public Object getCurrentMessageProcessingObject(AttributeStorage storage) {
        List messageProcessingTree = this.getMessageProcessingTree(storage);
        return messageProcessingTree.get(messageProcessingTree.size() - 1);
    }
}

