/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Context;
import com.sun.grizzly.Interceptor;
import com.sun.grizzly.WriteResult;
import com.sun.grizzly.asyncqueue.MessageCloner;
import com.sun.grizzly.nio.AbstractNIOAsyncQueueWriter;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.NIOTransport;
import com.sun.grizzly.nio.transport.TCPNIOTransport;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;

public class TCPNIOAsyncQueueWriter
extends AbstractNIOAsyncQueueWriter {
    public TCPNIOAsyncQueueWriter(NIOTransport transport) {
        super(transport);
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult> interceptor, MessageCloner<Buffer> cloner) throws IOException {
        if (dstAddress != null) {
            throw new UnsupportedOperationException("Destination address should be null for TCP!");
        }
        return super.write(connection, null, buffer, completionHandler, interceptor, cloner);
    }

    @Override
    protected int write0(Connection connection, SocketAddress dstAddress, Buffer buffer, WriteResult<Buffer, SocketAddress> currentResult) throws IOException {
        return ((TCPNIOTransport)this.transport).write(connection, buffer, currentResult);
    }

    @Override
    protected void onReadyToWrite(Connection connection) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        this.transport.getSelectorHandler().registerKey(nioConnection.getSelectorRunner(), nioConnection.getSelectionKey(), 4);
    }

    public Context context() {
        return null;
    }

    public void beforeProcess(Context context) throws IOException {
    }

    public void afterProcess(Context context) throws IOException {
    }
}

