/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.tmpselectors;

import com.sun.grizzly.Grizzly;
import com.sun.grizzly.Reader;
import com.sun.grizzly.Writer;
import com.sun.grizzly.nio.SelectorFactory;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorPool;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;

public class TemporarySelectorIO {
    protected TemporarySelectorPool selectorPool;
    private final Reader reader;
    private final Writer writer;

    public TemporarySelectorIO(Reader reader, Writer writer) {
        this(reader, writer, null);
    }

    public TemporarySelectorIO(Reader reader, Writer writer, TemporarySelectorPool selectorPool) {
        this.reader = reader;
        this.writer = writer;
        this.selectorPool = selectorPool;
    }

    public TemporarySelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public void setSelectorPool(TemporarySelectorPool selectorPool) {
        this.selectorPool = selectorPool;
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    protected void recycleTemporaryArtifacts(Selector selector, SelectionKey selectionKey) {
        if (selectionKey != null) {
            try {
                selectionKey.cancel();
            }
            catch (Exception e) {
                Grizzly.logger.log(Level.WARNING, "Unexpected exception, when canceling the SelectionKey: " + selectionKey, e);
            }
        }
        if (selector != null) {
            try {
                selector.selectNow();
                this.selectorPool.offer(selector);
            }
            catch (IOException e) {
                Grizzly.logger.log(Level.WARNING, "Temporary Selector failure. Creating new one", e);
                try {
                    this.selectorPool.offer(SelectorFactory.instance().create());
                }
                catch (IOException ee) {
                    Grizzly.logger.log(Level.WARNING, "Error creating new Selector", ee);
                }
            }
        }
    }
}

