/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio;

import com.sun.grizzly.AbstractWriter;
import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Context;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Interceptor;
import com.sun.grizzly.ProcessorResult;
import com.sun.grizzly.WriteResult;
import com.sun.grizzly.asyncqueue.AsyncQueue;
import com.sun.grizzly.asyncqueue.AsyncQueueWriter;
import com.sun.grizzly.asyncqueue.AsyncWriteQueueRecord;
import com.sun.grizzly.asyncqueue.MessageCloner;
import com.sun.grizzly.impl.FutureImpl;
import com.sun.grizzly.nio.AbstractNIOConnection;
import com.sun.grizzly.nio.NIOTransport;
import com.sun.grizzly.utils.LinkedTransferQueue;
import com.sun.grizzly.utils.ObjectPool;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public abstract class AbstractNIOAsyncQueueWriter
extends AbstractWriter<SocketAddress>
implements AsyncQueueWriter<SocketAddress> {
    protected NIOTransport transport;
    private static final Logger logger = Grizzly.logger;

    public AbstractNIOAsyncQueueWriter(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult> interceptor) throws IOException {
        return this.write(connection, dstAddress, buffer, completionHandler, interceptor, (MessageCloner<Buffer>)null);
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(Connection connection, SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler, Interceptor<WriteResult> interceptor, MessageCloner<Buffer> cloner) throws IOException {
        if (connection == null) {
            throw new IOException("Connection is null");
        }
        if (!connection.isOpen()) {
            throw new IOException("Connection is closed");
        }
        FutureImpl<WriteResult<Buffer, SocketAddress>> future = new FutureImpl<WriteResult<Buffer, SocketAddress>>();
        WriteResult<Buffer, SocketAddress> currentResult = new WriteResult<Buffer, SocketAddress>(connection);
        currentResult.setMessage(buffer);
        currentResult.setDstAddress(dstAddress);
        currentResult.setWrittenSize(0);
        AsyncQueue<AsyncWriteQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncWriteQueue();
        LinkedTransferQueue<AsyncWriteQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncWriteQueueRecord> currentElement = connectionQueue.getCurrentElement();
        ReentrantLock lock = connectionQueue.getQueuedActionLock();
        boolean isLockedByMe = false;
        AsyncWriteQueueRecord<SocketAddress> queueRecord = new AsyncWriteQueueRecord<SocketAddress>();
        queueRecord.set(buffer, future, currentResult, completionHandler, interceptor, dstAddress);
        try {
            if (currentElement.get() == null && lock.tryLock()) {
                isLockedByMe = true;
                if (currentElement.compareAndSet(null, queueRecord)) {
                    this.doWrite(connection, currentResult, completionHandler, dstAddress, buffer);
                } else {
                    isLockedByMe = false;
                    lock.unlock();
                }
            }
            if (isLockedByMe && this.isFinished(connection, buffer)) {
                this.onWriteCompleted(connection, queueRecord);
                AsyncWriteQueueRecord nextRecord = queue.poll();
                if (nextRecord != null) {
                    currentElement.set(nextRecord);
                    isLockedByMe = false;
                    lock.unlock();
                    this.onReadyToWrite(connection);
                } else {
                    currentElement.set(null);
                    isLockedByMe = false;
                    lock.unlock();
                    if (queue.peek() != null) {
                        this.onReadyToWrite(connection);
                    }
                }
            } else {
                if (cloner != null) {
                    buffer = cloner.clone(connection, buffer);
                    queueRecord.setBuffer(buffer);
                    queueRecord.setCloned(true);
                }
                boolean isRegisterForWriting = false;
                if (currentElement.get() != queueRecord) {
                    queue.offer(queueRecord);
                    if (!lock.isLocked()) {
                        isRegisterForWriting = true;
                    }
                } else {
                    isRegisterForWriting = true;
                    if (isLockedByMe) {
                        isLockedByMe = false;
                        lock.unlock();
                    }
                }
                if (isRegisterForWriting) {
                    this.onReadyToWrite(connection);
                }
            }
        }
        catch (IOException e) {
            this.onWriteFailure(connection, queueRecord, e);
            throw e;
        }
        finally {
            if (isLockedByMe) {
                lock.unlock();
            }
        }
        return future;
    }

    @Override
    public boolean isReady(Connection connection) {
        AsyncQueue<AsyncWriteQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue != null && (connectionQueue.getCurrentElement().get() != null || connectionQueue.getQueue() != null && !connectionQueue.getQueue().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processAsync(Connection connection) throws IOException {
        AsyncQueue<AsyncWriteQueueRecord> connectionQueue = ((AbstractNIOConnection)connection).getAsyncWriteQueue();
        LinkedTransferQueue<AsyncWriteQueueRecord> queue = connectionQueue.getQueue();
        AtomicReference<AsyncWriteQueueRecord> currentElement = connectionQueue.getCurrentElement();
        ReentrantLock lock = connectionQueue.getQueuedActionLock();
        boolean isLockedByMe = false;
        if (currentElement.get() == null) {
            AsyncWriteQueueRecord nextRecord = queue.peek();
            if (nextRecord == null || !lock.tryLock()) return;
            if (!queue.isEmpty() && currentElement.compareAndSet(null, nextRecord)) {
                queue.remove();
            }
        } else if (!lock.tryLock()) {
            return;
        }
        isLockedByMe = true;
        AsyncWriteQueueRecord queueRecord = null;
        try {
            while (currentElement.get() != null) {
                queueRecord = currentElement.get();
                WriteResult currentResult = (WriteResult)queueRecord.getCurrentResult();
                Buffer buffer = queueRecord.getBuffer();
                this.doWrite(connection, currentResult, queueRecord.getCompletionHandler(), (SocketAddress)queueRecord.getDstAddress(), buffer);
                if (this.isFinished(connection, buffer)) {
                    AsyncWriteQueueRecord nextRecord;
                    currentElement.set(queue.poll());
                    this.onWriteCompleted(connection, queueRecord);
                    if (currentElement.get() != null) continue;
                    if (isLockedByMe) {
                        isLockedByMe = false;
                        lock.unlock();
                    }
                    if ((nextRecord = queue.peek()) == null || !lock.tryLock()) return;
                    isLockedByMe = true;
                    if (queue.isEmpty() || !currentElement.compareAndSet(null, nextRecord)) continue;
                    queue.remove();
                    continue;
                }
                if (isLockedByMe) {
                    isLockedByMe = false;
                    lock.unlock();
                }
                this.onReadyToWrite(connection);
                return;
            }
            return;
        }
        catch (IOException e) {
            this.onWriteFailure(connection, queueRecord, e);
            return;
        }
        finally {
            if (isLockedByMe) {
                connectionQueue.getQueuedActionLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(Connection connection) {
        AbstractNIOConnection nioConnection = (AbstractNIOConnection)connection;
        AsyncQueue<AsyncWriteQueueRecord> writeQueue = nioConnection.getAsyncWriteQueue();
        if (writeQueue != null) {
            writeQueue.getQueuedActionLock().lock();
            try {
                AsyncWriteQueueRecord record = writeQueue.getCurrentElement().getAndSet(null);
                IOException error = new IOException("Connection closed");
                this.failWriteRecord(connection, record, error);
                LinkedTransferQueue<AsyncWriteQueueRecord> recordsQueue = writeQueue.getQueue();
                if (recordsQueue != null) {
                    while (!recordsQueue.isEmpty()) {
                        this.failWriteRecord(connection, recordsQueue.poll(), error);
                    }
                }
            }
            finally {
                writeQueue.getQueuedActionLock().unlock();
            }
        }
    }

    public ObjectPool getContextPool() {
        return null;
    }

    @Override
    public boolean isInterested(IOEvent ioEvent) {
        return ioEvent == IOEvent.WRITE;
    }

    public ProcessorResult process(Context context) throws IOException {
        this.processAsync(context.getConnection());
        return null;
    }

    @Override
    public void setInterested(IOEvent ioEvent, boolean isInterested) {
    }

    @Override
    public void close() {
    }

    protected <E> void doWrite(Connection connection, WriteResult currentResult, CompletionHandler completionHandler, SocketAddress dstAddress, Buffer buffer) throws IOException {
        this.write0(connection, dstAddress, buffer, currentResult);
    }

    protected void onWriteCompleted(Connection connection, AsyncWriteQueueRecord<?> record) throws IOException {
        FutureImpl future = (FutureImpl)record.getFuture();
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        future.setResult(currentResult);
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.completed(connection, currentResult);
        }
    }

    protected void onWriteIncompleted(Connection connection, AsyncWriteQueueRecord<?> record) throws IOException {
        WriteResult currentResult = (WriteResult)record.getCurrentResult();
        CompletionHandler completionHandler = record.getCompletionHandler();
        if (completionHandler != null) {
            completionHandler.updated(connection, currentResult);
        }
    }

    protected void onWriteFailure(Connection connection, AsyncWriteQueueRecord failedRecord, IOException e) {
        this.failWriteRecord(connection, failedRecord, e);
        try {
            connection.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void failWriteRecord(Connection connection, AsyncWriteQueueRecord record, Throwable e) {
        if (record == null) {
            return;
        }
        FutureImpl future = (FutureImpl)record.getFuture();
        if (!future.isDone()) {
            CompletionHandler completionHandler = record.getCompletionHandler();
            if (completionHandler != null) {
                completionHandler.failed(connection, e);
            }
            future.failure(e);
        }
    }

    private boolean isFinished(Connection connection, Buffer originalBuffer) {
        return !originalBuffer.hasRemaining();
    }

    protected abstract int write0(Connection var1, SocketAddress var2, Buffer var3, WriteResult<Buffer, SocketAddress> var4) throws IOException;

    protected abstract void onReadyToWrite(Connection var1) throws IOException;
}

